/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractArtifact;
import com.googlecode.t7mp.MyArtifactResolver;
import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.WebappArtifact;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

class TomcatArtifactDispatcher {
    protected MyArtifactResolver myArtifactResolver;
    protected List<AbstractArtifact> resolvedArtifacts = new ArrayList<AbstractArtifact>();
    protected File catalinaBaseDir;
    protected SetupUtil setupUtil;
    protected Log log;

    public TomcatArtifactDispatcher(MyArtifactResolver myArtifactResolver, File catalinaBaseDir, SetupUtil setupUtil, Log log) {
        this.myArtifactResolver = myArtifactResolver;
        this.catalinaBaseDir = catalinaBaseDir;
        this.setupUtil = setupUtil;
        this.log = log;
    }

    public TomcatArtifactDispatcher resolveArtifacts(List<? extends AbstractArtifact> artifacts) {
        for (AbstractArtifact abstractArtifact : artifacts) {
            Artifact artifact;
            this.log.debug((CharSequence)("Resolve artifact for " + abstractArtifact.toString()));
            if (!abstractArtifact.getGroupId().equals("local")) {
                try {
                    artifact = this.myArtifactResolver.resolve(abstractArtifact.getGroupId(), abstractArtifact.getArtifactId(), abstractArtifact.getVersion(), abstractArtifact.getType(), "compile");
                }
                catch (MojoExecutionException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
                abstractArtifact.setArtifact(artifact);
                this.resolvedArtifacts.add(abstractArtifact);
                continue;
            }
            artifact = new DefaultArtifact(abstractArtifact.getGroupId(), abstractArtifact.getArtifactId(), VersionRange.createFromVersion((String)abstractArtifact.getVersion()), "compile", abstractArtifact.getType(), null, (ArtifactHandler)new DefaultArtifactHandler("jar"), false);
            String resourceName = "/com/googlecode/t7mp/repo/" + abstractArtifact.getArtifactId() + "/" + abstractArtifact.getVersion() + "/" + abstractArtifact.getArtifactId() + "-" + abstractArtifact.getVersion() + ".jar";
            BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream(resourceName));
            try {
                File tempFile = File.createTempFile("local_Artifact", ".maven.tmp");
                tempFile.deleteOnExit();
                IOUtils.copy((InputStream)bis, (OutputStream)new FileOutputStream(tempFile));
                artifact.setFile(tempFile);
                abstractArtifact.setArtifact(artifact);
                this.resolvedArtifacts.add(abstractArtifact);
            }
            catch (FileNotFoundException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
        }
        return this;
    }

    public void copyTo(String directoryName) {
        for (AbstractArtifact artifact : this.resolvedArtifacts) {
            try {
                String targetFileName = this.createTargetFileName(artifact);
                File sourceFile = artifact.getArtifact().getFile();
                File targetFile = new File(this.catalinaBaseDir, "/" + directoryName + "/" + targetFileName);
                this.log.debug((CharSequence)("Copy artifact from " + sourceFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath()));
                this.setupUtil.copy(new FileInputStream(sourceFile), new FileOutputStream(targetFile));
            }
            catch (IOException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
        }
    }

    protected String createTargetFileName(AbstractArtifact abstractArtifact) {
        if (abstractArtifact.getClass().isAssignableFrom(WebappArtifact.class)) {
            return ((WebappArtifact)abstractArtifact).getContextPath() + "." + abstractArtifact.getType();
        }
        return abstractArtifact.getArtifactId() + "-" + abstractArtifact.getVersion() + "." + abstractArtifact.getType();
    }

    void clear() {
        this.resolvedArtifacts.clear();
    }
}

