/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.ForkedTomcatProcessShutdownHook;
import com.googlecode.t7mp.PreConditions;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.scanner.ScannerSetup;
import com.googlecode.t7mp.steps.DefaultContext;
import com.googlecode.t7mp.steps.StepSequence;
import com.googlecode.t7mp.steps.deployment.ForkedSetupSequence;
import com.googlecode.t7mp.steps.resources.CopySetenvScriptStep;
import com.googlecode.t7mp.util.SystemUtil;
import com.googlecode.t7mp.util.TomcatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunForkedMojo
extends AbstractT7Mojo {
    private static final long SLEEPTIME = 5000L;
    private Process p;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PreConditions.checkConfiguredTomcatVersion(this.getLog(), this.tomcatVersion);
        this.getSetupStepSequence().execute(new DefaultContext(this));
        this.setStartScriptPermissions(TomcatUtil.getBinDirectory(this.getCatalinaBase()));
        this.getLog().info((CharSequence)"Starting Tomcat ...");
        try {
            if (this.tomcatSetAwait) {
                this.startTomcat();
            } else {
                new Runner().start();
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void startTomcat() {
        ProcessBuilder processBuilder = new ProcessBuilder(TomcatUtil.getStartScriptName(), "run");
        processBuilder.directory(TomcatUtil.getBinDirectory(this.getCatalinaBase()));
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().putAll(this.systemProperties);
        int exitValue = -1;
        try {
            String line;
            this.p = processBuilder.start();
            ForkedTomcatProcessShutdownHook shutdownHook = new ForkedTomcatProcessShutdownHook(this.p, this.getLog());
            ScannerSetup.configureScanners(shutdownHook, this);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            InputStream is = this.p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = this.getNextLine(br)) != null) {
            }
            exitValue = this.p.waitFor();
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        this.getLog().info((CharSequence)("Exit-Value " + exitValue));
    }

    private String getNextLine(BufferedReader br) {
        String line;
        try {
            line = br.readLine();
            System.out.println(line);
        }
        catch (IOException e) {
            line = null;
        }
        return line;
    }

    private void setStartScriptPermissions(File binDirectory) {
        if (SystemUtil.isWindowsSystem()) {
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder("chmod", "755", "catalina.sh", "setclasspath.sh", "startup.sh", "shutdown.sh");
        processBuilder.directory(binDirectory);
        processBuilder.redirectErrorStream(true);
        int exitValue = -1;
        try {
            Process p = processBuilder.start();
            exitValue = p.waitFor();
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new TomcatSetupException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new TomcatSetupException(e.getMessage(), e);
        }
        this.getLog().debug((CharSequence)("SetStartScriptPermission return value " + exitValue));
    }

    protected StepSequence getSetupStepSequence() {
        ForkedSetupSequence seq = new ForkedSetupSequence();
        seq.add(new CopySetenvScriptStep());
        return seq;
    }

    class Runner
    extends Thread {
        Runner() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            RunForkedMojo.this.startTomcat();
        }
    }
}

