/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.PreConditions;
import com.googlecode.t7mp.TomcatShutdownHook;
import com.googlecode.t7mp.scanner.ScannerSetup;
import com.googlecode.t7mp.steps.DefaultContext;
import com.googlecode.t7mp.steps.StepSequence;
import com.googlecode.t7mp.steps.deployment.CopyJuliJarStep;
import com.googlecode.t7mp.steps.deployment.TomcatSetupSequence;
import com.googlecode.t7mp.util.CatalinaOutPrintStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.catalina.startup.Bootstrap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunMojo
extends AbstractT7Mojo {
    protected Bootstrap bootstrap;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PreConditions.checkConfiguredTomcatVersion(this.getLog(), this.tomcatVersion);
        this.getSetupStepSequence().execute(new DefaultContext(this));
        PrintStream originalSystemErr = System.err;
        this.bootstrap = this.getBootstrap();
        this.getLog().info((CharSequence)"Starting Tomcat ...");
        try {
            File catalinaout = new File(this.getCatalinaBase(), "/logs/catalina.out");
            CatalinaOutPrintStream catalinaOutputStream = new CatalinaOutPrintStream(originalSystemErr, new FileOutputStream(catalinaout), this.isSuspendConsoleOutput());
            System.setErr(catalinaOutputStream);
            this.bootstrap.init();
            TomcatShutdownHook shutdownHook = new TomcatShutdownHook(this.bootstrap, catalinaOutputStream);
            ScannerSetup.configureScanners(shutdownHook, this);
            if (this.tomcatSetAwait) {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                this.bootstrap.setAwait(this.tomcatSetAwait);
                this.bootstrap.start();
            } else {
                this.bootstrap.start();
                this.getPluginContext().put("com.googlecode.t7mp.Bootstrap", this.bootstrap);
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                this.getLog().info((CharSequence)"Tomcat started");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected StepSequence getSetupStepSequence() {
        TomcatSetupSequence seq = new TomcatSetupSequence();
        seq.add(new CopyJuliJarStep());
        return seq;
    }

    protected Bootstrap getBootstrap() {
        return new Bootstrap();
    }
}

