/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.scanner;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.googlecode.t7mp.scanner.FileSuffixPredicate;
import com.googlecode.t7mp.scanner.ModifiedFilePredicate;
import com.googlecode.t7mp.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;

public final class ModifiedFileTimerTask
extends TimerTask {
    private static final String DEF_STATIC = FilenameUtils.separatorsToSystem((String)"src/main/webapp/");
    private static final String DEF_CLASSES = FilenameUtils.separatorsToSystem((String)"target/classes/");
    private long lastrun = System.currentTimeMillis();
    private final File rootDirectory;
    private final File webappDirectory;
    private final List<String> suffixe;
    private final Log log;

    public ModifiedFileTimerTask(File rootDirectory, File webappDirectory, List<String> suffixe, Log log) {
        this.rootDirectory = rootDirectory;
        this.webappDirectory = webappDirectory;
        this.suffixe = suffixe;
        this.log = log;
    }

    @Override
    public void run() {
        long timeStamp = this.lastrun;
        this.lastrun = System.currentTimeMillis();
        Set<File> fileSet = FileUtil.getAllFiles(this.rootDirectory);
        Collection changedFiles = Collections2.filter(fileSet, (Predicate)Predicates.and((Predicate)new ModifiedFilePredicate(timeStamp), (Predicate)new FileSuffixPredicate(this.suffixe)));
        for (File file : changedFiles) {
            String absolutePath = file.getAbsolutePath();
            String def = this.getResourceDef(absolutePath);
            int endIndex = absolutePath.lastIndexOf(def);
            String copyFragment = absolutePath.substring(endIndex + def.length());
            File copyToFile = new File(this.webappDirectory, copyFragment);
            this.log.debug((CharSequence)("CHANGED: " + absolutePath));
            this.log.debug((CharSequence)("COPY TO : " + copyToFile.getAbsolutePath()));
            try {
                FileUtils.copyFile((File)file, (File)copyToFile);
                FileUtils.touch((File)copyToFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.log.debug((CharSequence)"-----------END SCAN-------------");
    }

    private String getResourceDef(String absolutePath) {
        if (absolutePath.lastIndexOf(DEF_STATIC) != -1) {
            return DEF_STATIC;
        }
        return DEF_CLASSES;
    }
}

