/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.scanner;

import com.googlecode.t7mp.scanner.ModifiedFileTimerTask;
import com.googlecode.t7mp.scanner.ScannerConfiguration;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.maven.plugin.logging.Log;

public final class Scanner {
    private static final int DEFAULT_DELAY = 10000;
    private static final int MILLIS = 1000;
    private final ScannerConfiguration scannerConfiguration;
    private Timer timer;
    private final Log log;

    public Scanner(ScannerConfiguration scannerConfiguration, Log log) {
        this.scannerConfiguration = scannerConfiguration;
        this.log = log;
    }

    public void start() {
        this.log.info((CharSequence)"Starting Scanner ....");
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new ModifiedFileTimerTask(this.scannerConfiguration.getRootDirectory(), this.scannerConfiguration.getWebappDirectory(), this.scannerConfiguration.getEndingsAsList(), this.log), 10000L, (long)(this.scannerConfiguration.getInterval() * 1000));
        this.log.info((CharSequence)"Scanner started");
    }

    public void stop() {
        this.log.info((CharSequence)"Stopping Scanner ...");
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.log.info((CharSequence)"Scanner stopped");
    }
}

