/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.resources;

import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.steps.Context;
import com.googlecode.t7mp.steps.Step;
import com.googlecode.t7mp.util.CommonsSetupUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CopyConfigResourceFromClasspath
implements Step {
    private static final String MSG_PREFIX = "Could not copy classpathresource ";
    private static final String MSG_SUFFIX = " to tomcat-conf directory";
    private static final String RESOURCEPATH = "/com/googlecode/t7mp/conf/";
    private SetupUtil setupUtil = new CommonsSetupUtil();
    private final String resource;

    public CopyConfigResourceFromClasspath(String resource) {
        this.resource = resource;
    }

    @Override
    public void execute(Context context) {
        File tomcatConfDirectory = new File(context.getMojo().getCatalinaBase(), "/conf/");
        try {
            FileOutputStream out = new FileOutputStream(new File(tomcatConfDirectory, this.resource));
            this.setupUtil.copy(this.getClass().getResourceAsStream(RESOURCEPATH + this.resource), out);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new TomcatSetupException(MSG_PREFIX + this.resource + MSG_SUFFIX, e);
        }
        catch (IOException e) {
            throw new TomcatSetupException(MSG_PREFIX + this.resource + MSG_SUFFIX, e);
        }
    }
}

