/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.googlecode.webutilities.common.WebUtilitiesResponseWrapper;
import com.googlecode.webutilities.filters.YUIMinFilter;
import com.googlecode.webutilities.filters.common.AbstractFilter;
import com.googlecode.webutilities.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureCompilerFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ClosureCompilerFilter.class.getName());
    CompilerOptions compilerOptions;
    JSSourceFile nullExtern = JSSourceFile.fromCode((String)"/dev/null", (String)"");
    private static final String PROCESSED_ATTR = YUIMinFilter.class.getName() + ".MINIFIED";

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.compilerOptions = ClosureCompilerFilter.buildCompilerOptionsFromConfig(config);
        LOGGER.debug("Filter initialized with: {}", (Object)this.compilerOptions.toString());
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean alreadyProcessed;
        HttpServletRequest rq = (HttpServletRequest)req;
        HttpServletResponse rs = (HttpServletResponse)resp;
        String url = rq.getRequestURI();
        String lowerUrl = url.toLowerCase();
        LOGGER.debug("Filtering URI: {}", (Object)url);
        boolean bl = alreadyProcessed = req.getAttribute(PROCESSED_ATTR) != null;
        if (!alreadyProcessed && this.isURLAccepted(url) && this.isUserAgentAccepted(rq.getHeader("User-Agent")) && (lowerUrl.endsWith(".js") || lowerUrl.endsWith(".json") || lowerUrl.endsWith(".css"))) {
            req.setAttribute(PROCESSED_ATTR, (Object)Boolean.TRUE);
            WebUtilitiesResponseWrapper wrapper = new WebUtilitiesResponseWrapper(rs);
            chain.doFilter(req, (ServletResponse)wrapper);
            PrintWriter out = resp.getWriter();
            String mime = wrapper.getContentType();
            if (!this.isMIMEAccepted(mime)) {
                ((Writer)out).write(wrapper.getContents());
                ((Writer)out).flush();
                LOGGER.trace("Not minifying. Mime {) not allowed.", (Object)mime);
                return;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(wrapper.getBytes());
            if (lowerUrl.endsWith(".js") || lowerUrl.endsWith(".json") || wrapper.getContentType() != null && (wrapper.getContentType().equals("text/javascript") || wrapper.getContentType().equals("application/json"))) {
                Compiler closureCompiler = new Compiler((ErrorManager)new BasicErrorManager(){

                    public void println(CheckLevel checkLevel, JSError jsError) {
                        if (checkLevel.equals((Object)CheckLevel.WARNING)) {
                            LOGGER.warn("Warning. {}", (Object)jsError);
                        } else if (checkLevel.equals((Object)CheckLevel.ERROR)) {
                            LOGGER.error("Error. {}", (Object)jsError);
                        }
                    }

                    protected void printSummary() {
                    }
                });
                LOGGER.trace("Compressing JS/JSON type");
                CompilationLevel level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
                level.setOptionsForCompilationLevel(this.compilerOptions);
                Result result = closureCompiler.compile(this.nullExtern, JSSourceFile.fromInputStream(null, (InputStream)is), this.compilerOptions);
                if (result.success) {
                    ((Writer)out).append(closureCompiler.toSource());
                }
            } else {
                LOGGER.trace("Not Compressing anything.");
                ((Writer)out).write(wrapper.getContents());
            }
            ((Writer)out).flush();
        } else {
            LOGGER.trace("Not minifying. URL/UserAgent not allowed.");
            chain.doFilter(req, resp);
        }
    }

    private static CompilerOptions buildCompilerOptionsFromConfig(FilterConfig config) {
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setCodingConvention(CodingConventions.getDefault());
        Enumeration initParams = config.getInitParameterNames();
        while (initParams.hasMoreElements()) {
            String name = ((String)initParams.nextElement()).trim();
            String value = config.getInitParameter(name);
            if ("acceptConstKeyword".equals(name)) {
                compilerOptions.setAcceptConstKeyword(Utils.readBoolean(value, false));
                continue;
            }
            if ("charset".equals(name)) {
                compilerOptions.setOutputCharset(Utils.readString(value, "UTF-8"));
                continue;
            }
            if ("compilationLevel".equals(name)) {
                CompilationLevel compilationLevel = CompilationLevel.valueOf((String)value);
                compilationLevel.setOptionsForCompilationLevel(compilerOptions);
                continue;
            }
            if ("formatting".equals(name)) {
                if ("PRETTY_PRINT".equals(value)) {
                    compilerOptions.prettyPrint = true;
                    continue;
                }
                if (!"PRINT_INPUT_DELIMITER".equals(value)) continue;
                compilerOptions.printInputDelimiter = true;
                continue;
            }
            if (!"loggingLevel".equals(name)) continue;
            Compiler.setLoggingLevel((Level)Level.parse(value));
        }
        return compilerOptions;
    }
}

