/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters;

import com.googlecode.webutilities.filters.common.AbstractFilter;
import com.googlecode.webutilities.filters.compression.CompressedHttpServletRequestWrapper;
import com.googlecode.webutilities.filters.compression.CompressedHttpServletResponseWrapper;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import com.googlecode.webutilities.util.Utils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CompressionFilter.class.getName());
    private int compressionThreshold = 131072;
    private static final String PROCESSED_ATTR = CompressionFilter.class.getName() + ".PROCESSED";
    private static final String COMPRESSED_ATTR = CompressionFilter.class.getName() + ".COMPRESSED";
    private static final String INIT_PARAM_COMPRESSION_THRESHOLD = "compressionThreshold";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        int compressionMinSize = Utils.readInt(filterConfig.getInitParameter(INIT_PARAM_COMPRESSION_THRESHOLD), this.compressionThreshold);
        if (compressionMinSize > 0) {
            this.compressionThreshold = compressionMinSize;
        }
        LOGGER.trace("Filter initialized with: {}:{}", new Object[]{INIT_PARAM_COMPRESSION_THRESHOLD, String.valueOf(this.compressionThreshold)});
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRequest req = this.getRequest(request);
        ServletResponse resp = this.getResponse(request, response);
        request.setAttribute(PROCESSED_ATTR, (Object)Boolean.TRUE);
        chain.doFilter(req, resp);
        if (resp instanceof CompressedHttpServletResponseWrapper) {
            CompressedHttpServletResponseWrapper compressedResponseWrapper = (CompressedHttpServletResponseWrapper)resp;
            try {
                compressedResponseWrapper.close();
            }
            catch (IOException ex) {
                LOGGER.error("Response was already closed: ", (Object)ex.toString());
            }
            if (compressedResponseWrapper.isCompressed()) {
                req.setAttribute(COMPRESSED_ATTR, (Object)Boolean.TRUE);
            }
        }
    }

    private ServletRequest getRequest(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            LOGGER.trace("No Compression: non http request");
            return request;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String contentEncoding = httpRequest.getHeader("Content-Encoding");
        if (contentEncoding == null) {
            LOGGER.trace("No Compression: Request content encoding is: {}", (Object)contentEncoding);
            return request;
        }
        if (!EncodedStreamsFactory.isRequestContentEncodingSupported(contentEncoding)) {
            LOGGER.trace("No Compression: unsupported request content encoding: {}", (Object)contentEncoding);
            return request;
        }
        LOGGER.debug("Decompressing request: content encoding : {}", (Object)contentEncoding);
        return new CompressedHttpServletRequestWrapper(httpRequest, EncodedStreamsFactory.getFactoryForContentEncoding(contentEncoding));
    }

    private String getAppropriateContentEncoding(String acceptEncoding) {
        String[] clientAccepts;
        if (acceptEncoding == null) {
            return null;
        }
        String contentEncoding = null;
        if ("identity".equals(acceptEncoding.trim())) {
            return contentEncoding;
        }
        for (String accepts : clientAccepts = acceptEncoding.trim().split("\\s*,\\s*")) {
            if ("identity".equals(accepts)) {
                return contentEncoding;
            }
            if (!EncodedStreamsFactory.SUPPORTED_ENCODINGS.containsKey(accepts)) continue;
            contentEncoding = accepts;
            break;
        }
        return contentEncoding;
    }

    private ServletResponse getResponse(ServletRequest request, ServletResponse response) {
        if (response.isCommitted() || request.getAttribute(PROCESSED_ATTR) != null) {
            LOGGER.trace("No Compression: Response committed or filter has already been applied");
            return response;
        }
        if (!(response instanceof HttpServletResponse) || !(request instanceof HttpServletRequest)) {
            LOGGER.trace("No Compression: non http request/response");
            return response;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String acceptEncoding = httpRequest.getHeader("Accept-Encoding");
        String contentEncoding = this.getAppropriateContentEncoding(acceptEncoding);
        if (contentEncoding == null) {
            LOGGER.trace("No Compression: Accept encoding is : {}", (Object)acceptEncoding);
            return response;
        }
        String requestURI = httpRequest.getRequestURI();
        if (!this.isURLAccepted(requestURI)) {
            LOGGER.trace("No Compression: For path: ", (Object)requestURI);
            return response;
        }
        String userAgent = httpRequest.getHeader("User-Agent");
        if (!this.isUserAgentAccepted(userAgent)) {
            LOGGER.trace("No Compression: For User-Agent: {}", (Object)userAgent);
            return response;
        }
        EncodedStreamsFactory encodedStreamsFactory = EncodedStreamsFactory.getFactoryForContentEncoding(contentEncoding);
        LOGGER.debug("Compressing response: content encoding : {}", (Object)contentEncoding);
        return new CompressedHttpServletResponseWrapper(httpResponse, encodedStreamsFactory, contentEncoding, this.compressionThreshold, this);
    }
}

