/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters;

import com.googlecode.webutilities.common.WebUtilitiesResponseWrapper;
import com.googlecode.webutilities.filters.common.AbstractFilter;
import com.googlecode.webutilities.util.Utils;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YUIMinFilter
extends AbstractFilter {
    private String charset = "UTF-8";
    private static final String INIT_PARAM_LINE_BREAK = "lineBreak";
    private static final String INIT_PARAM_NO_MUNGE = "noMunge";
    private static final String INIT_PARAM_PRESERVE_SEMI = "preserveSemi";
    private static final String INIT_PARAM_DISABLE_OPTIMIZATIONS = "disableOptimizations";
    private static final String INIT_PARAM_CHARSET = "charset";
    private int lineBreak = -1;
    private boolean noMunge = false;
    private boolean preserveSemi = false;
    private boolean disableOptimizations = false;
    private static final String PROCESSED_ATTR = YUIMinFilter.class.getName() + ".MINIFIED";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)YUIMinFilter.class.getName());

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean alreadyProcessed;
        HttpServletRequest rq = (HttpServletRequest)req;
        HttpServletResponse rs = (HttpServletResponse)resp;
        String url = rq.getRequestURI();
        String lowerUrl = url.toLowerCase();
        LOGGER.debug("Filtering URI: {}", (Object)url);
        boolean bl = alreadyProcessed = req.getAttribute(PROCESSED_ATTR) != null;
        if (!alreadyProcessed && this.isURLAccepted(url) && this.isUserAgentAccepted(rq.getHeader("User-Agent")) && (lowerUrl.endsWith(".js") || lowerUrl.endsWith(".json") || lowerUrl.endsWith(".css"))) {
            req.setAttribute(PROCESSED_ATTR, (Object)Boolean.TRUE);
            WebUtilitiesResponseWrapper wrapper = new WebUtilitiesResponseWrapper(rs);
            chain.doFilter(req, (ServletResponse)wrapper);
            PrintWriter out = resp.getWriter();
            String mime = wrapper.getContentType();
            if (!this.isMIMEAccepted(mime)) {
                ((Writer)out).write(wrapper.getContents());
                ((Writer)out).flush();
                LOGGER.trace("Not minifying. Mime {} not allowed", (Object)mime);
                return;
            }
            StringReader sr = new StringReader(new String(wrapper.getBytes(), this.charset));
            if (lowerUrl.endsWith(".js") || lowerUrl.endsWith(".json") || wrapper.getContentType() != null && (wrapper.getContentType().equals("text/javascript") || wrapper.getContentType().equals("application/json"))) {
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)sr, null);
                LOGGER.trace("Compressing JS/JSON type");
                StringWriter stringWriter = new StringWriter();
                compressor.compress((Writer)stringWriter, this.lineBreak, !this.noMunge, false, this.preserveSemi, this.disableOptimizations);
                this.writeCompressedResponse(resp, out, stringWriter);
            } else if (lowerUrl.endsWith(".css") || wrapper.getContentType() != null && wrapper.getContentType().equals("text/css")) {
                CssCompressor compressor = new CssCompressor((Reader)sr);
                LOGGER.trace("Compressing CSS type");
                StringWriter stringWriter = new StringWriter();
                compressor.compress((Writer)stringWriter, this.lineBreak);
                this.writeCompressedResponse(resp, out, stringWriter);
            } else {
                LOGGER.trace("Not Compressing anything.");
                ((Writer)out).write(wrapper.getContents());
            }
            ((Writer)out).flush();
        } else {
            LOGGER.trace("Not minifying. URL/UserAgent not allowed.");
            chain.doFilter(req, resp);
        }
    }

    private void writeCompressedResponse(ServletResponse resp, Writer out, StringWriter stringWriter) throws IOException {
        String compressed = stringWriter.toString();
        resp.setContentLength(compressed.length());
        out.write(compressed);
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        String string = this.charset = this.filterConfig.getInitParameter(INIT_PARAM_CHARSET) == null ? this.charset : this.filterConfig.getInitParameter(INIT_PARAM_CHARSET);
        if (!Charset.isSupported(this.charset)) {
            LOGGER.debug("Charset {}  not supported. Using default: {}", (Object)this.charset, (Object)"UTF-8");
            this.charset = "UTF-8";
        }
        this.lineBreak = Utils.readInt(this.filterConfig.getInitParameter(INIT_PARAM_LINE_BREAK), this.lineBreak);
        this.noMunge = Utils.readBoolean(this.filterConfig.getInitParameter(INIT_PARAM_NO_MUNGE), this.noMunge);
        this.preserveSemi = Utils.readBoolean(this.filterConfig.getInitParameter(INIT_PARAM_PRESERVE_SEMI), this.preserveSemi);
        this.disableOptimizations = Utils.readBoolean(this.filterConfig.getInitParameter(INIT_PARAM_DISABLE_OPTIMIZATIONS), this.disableOptimizations);
        LOGGER.debug("Filter initialized with: {\n\t{}:{},\n\t{}:{},\n\t{}:{}\n\t{}:{},\n\t{}:{}\n}", new Object[]{INIT_PARAM_LINE_BREAK, String.valueOf(this.lineBreak), INIT_PARAM_NO_MUNGE, String.valueOf(this.noMunge), INIT_PARAM_PRESERVE_SEMI, String.valueOf(this.preserveSemi), INIT_PARAM_DISABLE_OPTIMIZATIONS, String.valueOf(this.disableOptimizations), INIT_PARAM_CHARSET, this.charset});
    }
}

