/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.CompressedHttpServletResponseWrapper;
import com.googlecode.webutilities.filters.compression.CompressedOutput;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class CompressedServletOutputStream
extends ServletOutputStream {
    private final OutputStream uncompressedStream;
    private CompressedOutput compressed;
    private final EncodedStreamsFactory encodedStreamsFactory;
    private final CompressedHttpServletResponseWrapper compressedResponseWrapper;
    protected ByteArrayOutputStream buffer = null;
    private boolean useBuffer = true;
    private boolean closed;
    private boolean cancelled;
    private int maxSize;

    CompressedServletOutputStream(OutputStream uncompressedStream, EncodedStreamsFactory encodedStreamsFactory, CompressedHttpServletResponseWrapper compressedResponseWrapper, int threshold) {
        this.uncompressedStream = uncompressedStream;
        this.encodedStreamsFactory = encodedStreamsFactory;
        this.compressedResponseWrapper = compressedResponseWrapper;
        this.closed = false;
        this.cancelled = false;
        this.maxSize = threshold;
    }

    private OutputStream getCompressed() throws IOException {
        if (this.useBuffer || this.cancelled) {
            return this.uncompressedStream;
        }
        if (this.compressed == null) {
            this.compressed = this.encodedStreamsFactory.getCompressedStream(this.uncompressedStream);
            this.compressedResponseWrapper.useCompression();
        }
        return this.compressed.getCompressedOutputStream();
    }

    private void flushBufferToStream(OutputStream outputStream) throws IOException {
        if (this.buffer != null) {
            this.buffer.writeTo(outputStream);
            this.buffer.flush();
            this.buffer = null;
            this.useBuffer = false;
        }
    }

    private boolean canBuffer(int length) throws IOException {
        if (!this.useBuffer) {
            return this.useBuffer;
        }
        if (length > this.maxSize) {
            this.useBuffer = false;
            this.getCompressed();
        } else {
            if (this.buffer == null) {
                this.buffer = new ByteArrayOutputStream(this.maxSize);
            }
            this.useBuffer = this.buffer.size() + length <= this.maxSize;
        }
        return this.useBuffer;
    }

    public void write(byte[] b) throws IOException {
        this.assertOpen();
        if (this.canBuffer(b.length)) {
            this.buffer.write(b);
        } else {
            this.flushBufferToStream(this.getCompressed());
            this.getCompressed().write(b);
        }
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.assertOpen();
        if (this.canBuffer(length)) {
            this.buffer.write(b, offset, length);
        } else {
            this.flushBufferToStream(this.getCompressed());
            this.getCompressed().write(b, offset, length);
        }
    }

    public void write(int b) throws IOException {
        this.assertOpen();
        if (this.canBuffer(1)) {
            this.buffer.write(b);
        } else {
            this.flushBufferToStream(this.getCompressed());
            this.getCompressed().write(b);
        }
    }

    private void assertOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been already closed");
        }
    }

    void reset() {
        if (this.useBuffer && this.buffer != null) {
            this.buffer.reset();
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.compressedResponseWrapper.flushBuffer();
            this.closed = true;
            if (this.useBuffer || this.cancelled) {
                this.flushBufferToStream(this.uncompressedStream);
                this.compressedResponseWrapper.noCompression();
                this.uncompressedStream.close();
            } else {
                this.compressedResponseWrapper.useCompression();
                OutputStream outputStream = this.compressed.getCompressedOutputStream();
                this.flushBufferToStream(outputStream);
                outputStream.flush();
                this.compressed.finish();
                outputStream.close();
            }
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    void cancelCompression() throws IOException {
        if (this.useBuffer) {
            this.flushBufferToStream(this.uncompressedStream);
        }
        this.cancelled = true;
    }

    boolean isCancelled() {
        return this.cancelled;
    }
}

