/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.CompressedInput;
import com.googlecode.webutilities.filters.compression.CompressedOutput;
import com.googlecode.webutilities.filters.compression.DeflateEncodedStreamsFactory;
import com.googlecode.webutilities.filters.compression.GZIPEncodedStreamsFactory;
import com.googlecode.webutilities.filters.compression.ZIPEncodedStreamsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class EncodedStreamsFactory {
    private static final EncodedStreamsFactory GZIP_ENCODED_STREAMS_FACTORY = new GZIPEncodedStreamsFactory();
    private static final EncodedStreamsFactory ZIP_ENCODED_STREAMS_FACTORY = new ZIPEncodedStreamsFactory();
    private static final EncodedStreamsFactory DEFLATE_ENCODED_STREAMS_FACTORY = new DeflateEncodedStreamsFactory();
    public static final Map<String, EncodedStreamsFactory> SUPPORTED_ENCODINGS = EncodedStreamsFactory.getSupportedEncodingMap();

    private static Map<String, EncodedStreamsFactory> getSupportedEncodingMap() {
        if (SUPPORTED_ENCODINGS != null) {
            return SUPPORTED_ENCODINGS;
        }
        HashMap<String, EncodedStreamsFactory> map = new HashMap<String, EncodedStreamsFactory>();
        map.put("gzip", GZIP_ENCODED_STREAMS_FACTORY);
        map.put("compress", ZIP_ENCODED_STREAMS_FACTORY);
        map.put("deflate", DEFLATE_ENCODED_STREAMS_FACTORY);
        return Collections.unmodifiableMap(map);
    }

    public static boolean isRequestContentEncodingSupported(String contentEncoding) {
        return SUPPORTED_ENCODINGS.containsKey(contentEncoding);
    }

    public static EncodedStreamsFactory getFactoryForContentEncoding(String contentEncoding) {
        return SUPPORTED_ENCODINGS.get(contentEncoding);
    }

    public abstract CompressedOutput getCompressedStream(OutputStream var1) throws IOException;

    public abstract CompressedInput getCompressedStream(InputStream var1) throws IOException;
}

