/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.util;

import com.googlecode.webutilities.common.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Utils.class.getName());
    private static final String FINGERPRINT_SEPARATOR = "_wu_";
    private static final String PATH_ROOT = "/";
    private static final String PATH_CURRENT = "./";
    private static final String PATH_PARENT = "../";

    public static int readInt(String string, int defaultValue) {
        int returnValue;
        try {
            returnValue = Integer.parseInt(string);
        }
        catch (Exception e) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    public static long readLong(String string, long defaultValue) {
        long returnValue;
        try {
            returnValue = Long.parseLong(string);
        }
        catch (Exception e) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    public static boolean readBoolean(String string, boolean defaultValue) {
        if (string == null || !string.toLowerCase().matches("^true|t|on|1|y|false|f|off|0|n$")) {
            return defaultValue;
        }
        return string.toLowerCase().matches("^true|t|on|1|y$");
    }

    public static String readString(String string, String defaultValue) {
        if (string == null || string.equals("")) {
            return defaultValue;
        }
        return string;
    }

    public static String detectExtension(String requestURI) {
        String requestURIExtension = null;
        if (requestURI.endsWith(".js")) {
            requestURIExtension = ".js";
        } else if (requestURI.endsWith(".json")) {
            requestURIExtension = ".json";
        } else if (requestURI.endsWith(".css")) {
            requestURIExtension = ".css";
        }
        return requestURIExtension;
    }

    public static String selectMimeByFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.toLowerCase().endsWith(".js")) {
            return "text/javascript";
        }
        if (filePath.toLowerCase().endsWith(".css")) {
            return "text/css";
        }
        if (filePath.toLowerCase().endsWith(".json")) {
            return "application/json";
        }
        String guess = URLConnection.guessContentTypeFromName(filePath);
        return guess != null ? guess : "application/octet-stream";
    }

    public static String selectMimeForExtension(String extensionOrFile) {
        if (".js".equals(extensionOrFile)) {
            return "text/javascript";
        }
        if (".css".equals(extensionOrFile)) {
            return "text/css";
        }
        if (".json".equals(extensionOrFile)) {
            return "application/json";
        }
        return Utils.selectMimeByFile(extensionOrFile);
    }

    public static String buildProperPath(String parentPath, String relativePathFromParent) {
        String path;
        if (relativePathFromParent == null) {
            return null;
        }
        if (parentPath != null) {
            parentPath = parentPath.trim();
        }
        if (relativePathFromParent.startsWith(PATH_CURRENT)) {
            relativePathFromParent = relativePathFromParent.replaceFirst("(./)+", "");
        }
        if (relativePathFromParent.startsWith(PATH_ROOT)) {
            path = relativePathFromParent;
        } else if (relativePathFromParent.startsWith(PATH_PARENT)) {
            while (relativePathFromParent.startsWith(PATH_PARENT)) {
                if ((relativePathFromParent = relativePathFromParent.replaceFirst(PATH_PARENT, "")).startsWith(PATH_CURRENT)) {
                    relativePathFromParent = relativePathFromParent.replaceFirst(PATH_CURRENT, "");
                }
                parentPath = parentPath == null || parentPath.equals(PATH_ROOT) ? PATH_ROOT : Utils.getParentPath(parentPath);
            }
            path = parentPath + PATH_ROOT + relativePathFromParent;
        } else {
            path = parentPath + PATH_ROOT + relativePathFromParent;
        }
        return path.replaceAll("(/|\\./)+", "$1");
    }

    private static String simpleHashOf(String resourceRealPath) {
        if (resourceRealPath == null) {
            return null;
        }
        File resource = new File(resourceRealPath);
        if (!resource.exists()) {
            return null;
        }
        long lastModified = resource.lastModified();
        long size = resource.length();
        return String.format("%s#%s", lastModified, size);
    }

    public static List<String> findResourcesToMerge(String contextPath, String requestURI) {
        String extension = Utils.detectExtension(requestURI);
        if (extension == null) {
            extension = "";
        }
        requestURI = requestURI.replaceFirst(contextPath, "");
        requestURI = requestURI.substring(0, requestURI.lastIndexOf(extension));
        String[] resourcesPath = requestURI.split(",");
        ArrayList<String> resources = new ArrayList<String>();
        String currentPath = PATH_ROOT;
        for (String filePath : resourcesPath) {
            String path = Utils.buildProperPath(currentPath, filePath) + extension;
            if (filePath == null) continue;
            currentPath = Utils.getParentPath(path);
            if (resources.contains(path)) continue;
            resources.add(path);
        }
        return resources;
    }

    public static boolean isAnyResourceModifiedSince(List<String> resources, long sinceTime, ServletContext servletContext) {
        for (String resourcePath : resources) {
            File resource;
            long lastModified;
            if ((resourcePath = servletContext.getRealPath(resourcePath)) == null || (lastModified = Utils.readDateFromHeader(Utils.forHeaderDate((resource = new File(resourcePath)).lastModified())).getTime()) <= sinceTime) continue;
            return true;
        }
        return false;
    }

    public static long getLastModifiedFor(List<String> resources, ServletContext servletContext) {
        long lastModified = 0L;
        for (String resourcePath : resources) {
            File resource;
            long resourceLastModified;
            if ((resourcePath = servletContext.getRealPath(resourcePath)) == null || (resourceLastModified = (resource = new File(resourcePath)).lastModified()) <= lastModified) continue;
            lastModified = resourceLastModified;
        }
        return lastModified;
    }

    public static boolean isAnyResourceETagModified(List<String> resources, String requestETag, String actualETag, ServletContext servletContext) {
        if (actualETag == null && requestETag != null) {
            actualETag = Utils.buildETagForResources(resources, servletContext);
        }
        if (requestETag != null && actualETag != null) {
            return !(requestETag = requestETag.replace("-gzip", "")).equals(actualETag);
        }
        return true;
    }

    public static String buildETagForResources(List<String> resourcesRelativePath, ServletContext context) {
        String hashForETag = "";
        for (String relativePath : resourcesRelativePath) {
            String hash = Utils.buildETagForResource(relativePath, context);
            hashForETag = hashForETag + (hash != null ? hash : "");
        }
        return hashForETag.length() > 0 ? (resourcesRelativePath.size() > 2 ? Utils.hexDigestString(hashForETag.getBytes()) : hashForETag) : null;
    }

    public static boolean updateReferenceMap(String cssFilePath, String imgFilePath) {
        if (imgFilePath != null) {
            File imgFile = new File(imgFilePath);
            List<String> referencesList = Constants.CSS_IMG_REFERENCES.get(cssFilePath);
            if (imgFile.isFile() && imgFile.exists()) {
                File cssFile;
                if (referencesList == null) {
                    referencesList = new LinkedList<String>();
                    referencesList.add(imgFilePath);
                    Constants.CSS_IMG_REFERENCES.put(cssFilePath, referencesList);
                }
                if (!referencesList.contains(imgFilePath)) {
                    referencesList.add(imgFilePath);
                }
                if ((cssFile = new File(cssFilePath)).lastModified() < imgFile.lastModified()) {
                    return cssFile.setLastModified(new Date().getTime());
                }
            } else if (referencesList != null) {
                referencesList.remove(imgFilePath);
            }
        }
        return false;
    }

    public static boolean isProtocolURL(String url) {
        return url != null && url.trim().length() != 0 && url.matches("^[a-z0-9\\+\\.\\-]+:.*$");
    }

    public static String buildETagForResource(String relativePath, ServletContext context) {
        String hashForETag = ":";
        String realPath = context.getRealPath(relativePath);
        if (realPath == null) {
            return null;
        }
        File realFile = new File(realPath);
        if (!realFile.isFile() || !realFile.exists()) {
            return null;
        }
        if (realPath.endsWith(".css")) {
            long cssLastModified = realFile.lastModified();
            List<String> referencedImages = Constants.CSS_IMG_REFERENCES.get(realPath);
            if (referencedImages != null) {
                for (String referenceImage : referencedImages) {
                    File imgFile = new File(referenceImage);
                    if (!imgFile.isFile() || !imgFile.exists() || cssLastModified >= imgFile.lastModified()) continue;
                    realFile.setLastModified(new Date().getTime());
                    break;
                }
            } else {
                try {
                    String line;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(realPath));
                    block4: while ((line = bufferedReader.readLine()) != null) {
                        Matcher matcher = Constants.CSS_IMG_URL_PATTERN.matcher(line);
                        while (matcher.find()) {
                            String refImgPath = matcher.group(1);
                            if (Utils.isProtocolURL(refImgPath)) continue;
                            String resolvedImgPath = refImgPath;
                            if (!refImgPath.startsWith(PATH_ROOT)) {
                                resolvedImgPath = Utils.buildProperPath(Utils.getParentPath(realPath), refImgPath);
                            }
                            if (!Utils.updateReferenceMap(realPath, resolvedImgPath)) continue;
                            continue block4;
                        }
                    }
                }
                catch (FileNotFoundException ex) {
                    LOGGER.warn("File not found.", (Throwable)ex);
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to read/touch {}. ex: {}", (Object)realPath, (Object)ex);
                }
            }
        }
        String hash = Utils.simpleHashOf(realPath);
        hashForETag = hashForETag + (hash != null ? ":" + hash : "");
        return hashForETag.length() > 0 ? Utils.hexDigestString(hashForETag.getBytes()) : null;
    }

    public static Date readDateFromHeader(String headerDateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Constants.DEFAULT_LOCALE_US);
        try {
            return simpleDateFormat.parse(headerDateString);
        }
        catch (Exception e) {
            LOGGER.warn("Date parsing using HTTP header pattern failed.");
            simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Constants.DEFAULT_LOCALE_US);
            try {
                return simpleDateFormat.parse(headerDateString);
            }
            catch (Exception e2) {
                LOGGER.warn("Date parsing using RFC_1123 pattern failed.");
                simpleDateFormat = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", Constants.DEFAULT_LOCALE_US);
                try {
                    return simpleDateFormat.parse(headerDateString);
                }
                catch (Exception e3) {
                    LOGGER.warn("Date parsing using RFC_1036 pattern failed.");
                    simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Constants.DEFAULT_LOCALE_US);
                    try {
                        return simpleDateFormat.parse(headerDateString);
                    }
                    catch (Exception e4) {
                        LOGGER.warn("Date is not even ANSI C pattern.");
                        return null;
                    }
                }
            }
        }
    }

    public static String forHeaderDate(long time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Constants.DEFAULT_LOCALE_US);
        return simpleDateFormat.format(time);
    }

    public static String hexDigestString(byte[] data) {
        MessageDigest md5Digest = null;
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("Unable to use MD5 for digesting.", (Throwable)ex);
        }
        if (md5Digest != null) {
            data = md5Digest.digest(data);
        }
        char[] HEX_CHARS = "0123456789abcdef".toCharArray();
        char[] hex = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            hex[2 * i] = HEX_CHARS[(data[i] & 0xF0) >>> 4];
            hex[2 * i + 1] = HEX_CHARS[data[i] & 0xF];
        }
        return new String(hex);
    }

    public static String addFingerPrint(String fingerPrint, String url) {
        if (fingerPrint != null) {
            int li = url.lastIndexOf(".");
            url = url.substring(0, li) + FINGERPRINT_SEPARATOR + fingerPrint + url.substring(li);
        }
        return url;
    }

    public static String removeFingerPrint(String url) {
        int from = url.indexOf(FINGERPRINT_SEPARATOR);
        if (from <= 0) {
            return url;
        }
        int to = url.lastIndexOf(".");
        return url.substring(0, from) + url.substring(to);
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).endsWith(PATH_ROOT) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        int lastIndex = path.lastIndexOf(PATH_ROOT);
        if (path.length() > 1 && lastIndex > 0) {
            return path.substring(0, lastIndex);
        }
        return PATH_ROOT;
    }

    private Utils() {
    }
}

