/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.common;

import com.googlecode.webutilities.common.WebUtilitiesResponseOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtilitiesResponseWrapper
extends HttpServletResponseWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)WebUtilitiesResponseWrapper.class.getName());
    private WebUtilitiesResponseOutputStream stream;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Set<Cookie> cookies = new HashSet<Cookie>();
    private String contentType;
    private int status = 0;
    private boolean getWriterCalled = false;
    private boolean getStreamCalled = false;
    private PrintWriter printWriter;

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        this.cookies.add(cookie);
    }

    public void setStatus(int sc, String sm) {
        if (this.status != 0) {
            return;
        }
        super.setStatus(sc, sm);
        this.status = sc;
    }

    public void setStatus(int sc) {
        if (this.status != 0) {
            return;
        }
        super.setStatus(sc);
        this.status = sc;
    }

    public void sendError(int sc) throws IOException {
        if (this.status != 0) {
            return;
        }
        super.sendError(sc);
        this.status = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.status != 0) {
            return;
        }
        super.sendError(sc, msg);
        this.status = sc;
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        this.headers.put(name, date);
    }

    public void addHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else {
            super.addHeader(name, value);
            this.headers.put(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.headers.put(name, value);
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.headers.put(name, date);
    }

    public void setHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else {
            super.setHeader(name, value);
            this.headers.put(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.headers.put(name, value);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getWriterCalled) {
            throw new IllegalStateException("getWriter already called.");
        }
        this.getStreamCalled = true;
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.getStreamCalled) {
            throw new IllegalStateException("getStream already called.");
        }
        this.getWriterCalled = true;
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter((OutputStream)((Object)this.stream));
        }
        return this.printWriter;
    }

    public int getStatus() {
        return this.status;
    }

    private void flushWriter() {
        if (this.getWriterCalled && this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public void flushBuffer() throws IOException {
        this.flushWriter();
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public void reset() {
        this.flushWriter();
        if (this.stream != null) {
            this.stream.reset();
        }
    }

    public void resetBuffer() {
        this.flushWriter();
        if (this.stream != null) {
            this.stream.reset();
        }
    }

    public String getContents() {
        return new String(this.getBytes());
    }

    public byte[] getBytes() {
        return this.stream.getByteArrayOutputStream().toByteArray();
    }

    public WebUtilitiesResponseWrapper(HttpServletResponse response) {
        super(response);
        this.stream = new WebUtilitiesResponseOutputStream(this);
    }

    public void fill(HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(this.getCharacterEncoding());
        response.setContentType(this.getContentType());
        for (Cookie cookie : this.getCookies()) {
            response.addCookie(cookie);
        }
        for (String headerName : this.getHeaders().keySet()) {
            Object value = this.getHeaders().get(headerName);
            if (value instanceof Long) {
                response.setDateHeader(headerName, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Integer) {
                response.setIntHeader(headerName, ((Integer)value).intValue());
                continue;
            }
            response.setHeader(headerName, value.toString());
        }
        if (this.getStatus() > 0) {
            response.setStatus(this.getStatus());
        }
        this.flushWriter();
        try {
            response.getOutputStream().write(this.getBytes());
            response.getOutputStream().close();
        }
        catch (RuntimeException ex) {
            try {
                response.getWriter().write(this.getContents());
                response.getWriter().close();
            }
            catch (Exception ex1) {
                LOGGER.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
        if (response instanceof WebUtilitiesResponseWrapper) {
            ((WebUtilitiesResponseWrapper)response).fill((HttpServletResponse)((WebUtilitiesResponseWrapper)response).getResponse());
        }
    }
}

