/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.googlecode.webutilities.common.WebUtilitiesResponseWrapper;
import com.googlecode.webutilities.filters.common.AbstractFilter;
import com.googlecode.webutilities.servlets.JSCSSMergeServlet;
import com.googlecode.webutilities.util.Utils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCacheFilter
extends AbstractFilter {
    private Cache<String, CacheObject> cache;
    private int resetTime = 0;
    private long lastResetTime;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResponseCacheFilter.class.getName());
    private static final String INIT_PARAM_RELOAD_TIME = "reloadTime";
    private static final String INIT_PARAM_RESET_TIME = "resetTime";

    private static Cache<String, CacheObject> buildCache(int reloadAfterWrite) {
        CacheBuilder builder = CacheBuilder.newBuilder().softValues();
        if (reloadAfterWrite > 0) {
            builder.expireAfterWrite((long)reloadAfterWrite, TimeUnit.SECONDS);
        }
        return builder.build();
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        int reloadTime = Utils.readInt(filterConfig.getInitParameter(INIT_PARAM_RELOAD_TIME), 0);
        this.resetTime = Utils.readInt(filterConfig.getInitParameter(INIT_PARAM_RESET_TIME), this.resetTime);
        this.lastResetTime = new Date().getTime();
        if (this.cache == null) {
            this.cache = ResponseCacheFilter.buildCache(reloadTime);
        }
        LOGGER.debug("Cache Filter initialized with: {}:{},\n{}:{}", new Object[]{INIT_PARAM_RELOAD_TIME, String.valueOf(reloadTime), INIT_PARAM_RESET_TIME, String.valueOf(this.resetTime)});
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        JSCSSMergeServlet.ResourceStatus status;
        boolean skipCache;
        boolean resetCache;
        boolean expireCache;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String url = httpServletRequest.getRequestURI();
        if (!this.isURLAccepted(url) || !this.isUserAgentAccepted(httpServletRequest.getHeader("User-Agent"))) {
            LOGGER.debug("Skipping Cache filter for: {}", (Object)url);
            LOGGER.debug("URL or UserAgent not accepted");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        long now = new Date().getTime();
        CacheObject cacheObject = (CacheObject)this.cache.getIfPresent((Object)url);
        boolean bl = expireCache = httpServletRequest.getParameter("_expirecache_") != null;
        if (expireCache) {
            LOGGER.trace("Removing Cache for {}  due to URL parameter.", (Object)url);
            this.cache.invalidate((Object)url);
        }
        boolean bl2 = resetCache = httpServletRequest.getParameter("_resetcache_") != null || this.resetTime > 0 && (now - this.lastResetTime) / 1000L > (long)this.resetTime;
        if (resetCache) {
            LOGGER.trace("Resetting whole Cache for {} due to URL parameter.", (Object)url);
            this.cache.invalidateAll();
            this.lastResetTime = now;
        }
        boolean bl3 = skipCache = httpServletRequest.getParameter("_dbg_") != null || httpServletRequest.getParameter("_skipcache_") != null;
        if (skipCache) {
            filterChain.doFilter(servletRequest, servletResponse);
            LOGGER.trace("Skipping Cache for {} due to URL parameter.", (Object)url);
            return;
        }
        List<String> requestedResources = Utils.findResourcesToMerge(httpServletRequest.getContextPath(), url);
        ServletContext context = this.filterConfig.getServletContext();
        String extensionOrPath = Utils.detectExtension(url);
        if (extensionOrPath == null) {
            extensionOrPath = requestedResources.get(0);
        }
        if ((status = JSCSSMergeServlet.isNotModified(context, httpServletRequest, requestedResources, false)).isNotModified()) {
            LOGGER.trace("Resources Not Modified. Sending 304.");
            this.cache.invalidate((Object)url);
            JSCSSMergeServlet.sendNotModified(httpServletResponse, extensionOrPath, status.getActualETag(), 10080L, "public");
            return;
        }
        boolean cacheFound = false;
        if (cacheObject != null && cacheObject.getWebUtilitiesResponseWrapper() != null) {
            if (requestedResources != null && Utils.isAnyResourceModifiedSince(requestedResources, cacheObject.getTime(), context)) {
                LOGGER.trace("Some resources have been modified since last cache: {}", (Object)url);
                this.cache.invalidate((Object)url);
                cacheFound = false;
            } else {
                LOGGER.trace("Found valid cached response.");
                cacheFound = true;
            }
        }
        if (cacheFound) {
            LOGGER.debug("Returning Cached response.");
            cacheObject.getWebUtilitiesResponseWrapper().fill(httpServletResponse);
        } else {
            LOGGER.trace("Cache not found or invalidated");
            WebUtilitiesResponseWrapper wrapper = new WebUtilitiesResponseWrapper(httpServletResponse);
            filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
            if (this.isMIMEAccepted(wrapper.getContentType()) && !expireCache && !resetCache && wrapper.getStatus() == 200) {
                this.cache.put((Object)url, (Object)new CacheObject(Utils.getLastModifiedFor(requestedResources, context), wrapper));
                LOGGER.debug("Cache added for: {}", (Object)url);
            } else {
                LOGGER.trace("Cache NOT added for: {}", (Object)url);
                LOGGER.trace("is MIME not accepted: {}", (Object)this.isMIMEAccepted(wrapper.getContentType()));
                LOGGER.trace("is expireCache: {}", (Object)expireCache);
                LOGGER.trace("is resetCache: {}", (Object)resetCache);
            }
            wrapper.fill(httpServletResponse);
        }
    }

    private class CacheObject {
        private long time;
        private WebUtilitiesResponseWrapper webUtilitiesResponseWrapper;

        CacheObject(long time, WebUtilitiesResponseWrapper webUtilitiesResponseWrapper) {
            this.time = time;
            this.webUtilitiesResponseWrapper = webUtilitiesResponseWrapper;
        }

        public long getTime() {
            return this.time;
        }

        public WebUtilitiesResponseWrapper getWebUtilitiesResponseWrapper() {
            return this.webUtilitiesResponseWrapper;
        }
    }
}

