/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.common.WebUtilitiesResponseWrapper;
import com.googlecode.webutilities.filters.common.IgnoreAcceptContext;
import com.googlecode.webutilities.filters.compression.CompressedServletOutputStream;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedHttpServletResponseWrapper
extends WebUtilitiesResponseWrapper {
    private final HttpServletResponse httpResponse;
    private final String compressedContentEncoding;
    private final EncodedStreamsFactory encodedStreamsFactory;
    private CompressedServletOutputStream compressingStream;
    private PrintWriter printWriter;
    private boolean getOutputStreamCalled;
    private boolean getWriterCalled;
    private boolean compressing;
    private long savedContentLength;
    private boolean savedContentLengthSet;
    private String savedContentEncoding;
    private String savedETag;
    private IgnoreAcceptContext ignoreAcceptContext;
    private boolean mimeIgnored;
    private boolean noTransformSet;
    private int threshold = 131072;
    private static final List<String> UNALLOWED_HEADERS = new ArrayList<String>();
    private static final Logger LOGGER;

    public CompressedHttpServletResponseWrapper(HttpServletResponse httpResponse, EncodedStreamsFactory encodedStreamsFactory, String contentEncoding, int threshold, IgnoreAcceptContext ignoreAcceptContext) {
        super(httpResponse);
        this.httpResponse = httpResponse;
        this.compressedContentEncoding = contentEncoding;
        this.compressing = false;
        this.encodedStreamsFactory = encodedStreamsFactory;
        this.mimeIgnored = false;
        this.threshold = threshold;
        this.ignoreAcceptContext = ignoreAcceptContext;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getWriterCalled) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        this.getOutputStreamCalled = true;
        return this.getCompressedServletOutputStream();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.getOutputStreamCalled) {
            throw new IllegalStateException("getCompressingOutputStream() has already been called");
        }
        this.getWriterCalled = true;
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.getCompressedServletOutputStream()), this.getCharacterEncoding()), true);
        }
        return this.printWriter;
    }

    @Override
    public void addHeader(String name, String value) {
        if ("Cache-Control".equalsIgnoreCase(name)) {
            this.httpResponse.addHeader("Cache-Control", value);
            if (value.contains("no-transform")) {
                LOGGER.trace("No compression: due to no-transform");
                this.noTransformSet = true;
                this.cancelCompression();
            }
        } else if ("Content-Encoding".equalsIgnoreCase(name)) {
            this.savedContentEncoding = value;
            if (CompressedHttpServletResponseWrapper.alreadyCompressedEncoding(value)) {
                this.cancelCompression();
            }
        } else if ("Content-Length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        } else if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("ETag".equalsIgnoreCase(name)) {
            this.savedETag = value;
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.addHeader(name, value);
        }
    }

    @Override
    public void addIntHeader(String name, int value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.setContentLength(value);
        } else if ("ETag".equalsIgnoreCase(name)) {
            this.savedETag = String.valueOf(value);
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.addIntHeader(name, value);
        }
    }

    @Override
    public void addDateHeader(String name, long value) {
        if (this.isAllowedHeader(name)) {
            this.httpResponse.addDateHeader(name, value);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if ("Cache-Control".equalsIgnoreCase(name)) {
            this.httpResponse.setHeader("Cache-Control", value);
            if (value.contains("no-transform")) {
                LOGGER.trace("No compression: due to no-transform directive");
                this.noTransformSet = true;
                this.cancelCompression();
            }
        } else if ("Content-Encoding".equalsIgnoreCase(name)) {
            this.savedContentEncoding = value;
            if (CompressedHttpServletResponseWrapper.alreadyCompressedEncoding(value)) {
                this.cancelCompression();
            }
        } else if ("Content-Length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        } else if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("ETag".equalsIgnoreCase(name)) {
            this.savedETag = value;
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.setHeader(name, value);
        }
    }

    private void cancelCompression() {
        if (this.compressingStream != null) {
            try {
                LOGGER.trace("Cancelling compression.");
                this.compressingStream.cancelCompression();
            }
            catch (IOException ioe) {
                LOGGER.error("Error while cancelling compression.", (Throwable)ioe);
            }
        }
    }

    private void setETagHeader() {
        if (this.savedETag != null) {
            if (this.compressing) {
                this.httpResponse.setHeader("ETag", this.savedETag + '-' + this.compressedContentEncoding);
            } else {
                this.httpResponse.setHeader("ETag", this.savedETag);
            }
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.setContentLength(value);
        } else if ("ETag".equalsIgnoreCase(name)) {
            this.savedETag = String.valueOf(value);
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.setIntHeader(name, value);
        }
    }

    @Override
    public void setDateHeader(String name, long value) {
        if (this.isAllowedHeader(name)) {
            this.httpResponse.setDateHeader(name, value);
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        this.flushWriter();
        if (this.compressingStream != null) {
            this.compressingStream.flush();
        }
    }

    @Override
    public void reset() {
        this.flushWriter();
        if (this.compressingStream != null) {
            this.compressingStream.reset();
        }
        this.httpResponse.reset();
        if (this.compressing) {
            this.setCompressionResponseHeaders();
        } else {
            this.setNonCompressionResponseHeaders();
        }
    }

    @Override
    public void resetBuffer() {
        this.flushWriter();
        if (this.compressingStream != null) {
            this.compressingStream.reset();
        }
        this.httpResponse.resetBuffer();
    }

    public void setContentLength(int contentLength) {
        this.setContentLength((long)contentLength);
    }

    private void setContentLength(long contentLength) {
        if (!this.compressing) {
            this.savedContentLength = contentLength;
            this.savedContentLengthSet = true;
            if (this.compressingStream != null && this.compressingStream.isCancelled()) {
                this.httpResponse.setHeader("Content-Length", String.valueOf(contentLength));
            }
        }
    }

    @Override
    public void setContentType(String contentType) {
        this.httpResponse.setContentType(contentType);
        boolean bl = this.mimeIgnored = this.ignoreAcceptContext != null && !this.ignoreAcceptContext.isMIMEAccepted(contentType);
        if (this.mimeIgnored && this.compressingStream != null) {
            this.cancelCompression();
        }
    }

    public boolean isCompressed() {
        return this.compressing;
    }

    public void close() throws IOException {
        if (this.compressingStream != null && !this.compressingStream.isClosed()) {
            this.compressingStream.close();
        }
    }

    private void setCompressionResponseHeaders() {
        this.httpResponse.addHeader("Vary", "Accept-Encoding");
        String fullContentEncodingHeader = this.savedContentEncoding == null ? this.compressedContentEncoding : this.savedContentEncoding + ',' + this.compressedContentEncoding;
        this.httpResponse.setHeader("Content-Encoding", fullContentEncodingHeader);
        this.setETagHeader();
    }

    private void setNonCompressionResponseHeaders() {
        if (this.savedContentLengthSet) {
            this.httpResponse.setHeader("Content-Length", String.valueOf(this.savedContentLength));
        }
        if (this.savedContentEncoding != null) {
            this.httpResponse.setHeader("Content-Encoding", this.savedContentEncoding);
        }
    }

    void noCompression() {
        assert (!this.compressing);
        this.setNonCompressionResponseHeaders();
    }

    void useCompression() {
        LOGGER.trace("Switching to compression");
        this.compressing = true;
        this.setCompressionResponseHeaders();
    }

    private boolean isAllowedHeader(String header) {
        return header == null || !UNALLOWED_HEADERS.contains(header.toLowerCase());
    }

    private void flushWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    private static boolean alreadyCompressedEncoding(String encoding) {
        return encoding != null && EncodedStreamsFactory.SUPPORTED_ENCODINGS.containsKey(encoding);
    }

    private CompressedServletOutputStream getCompressedServletOutputStream() throws IOException {
        if (this.compressingStream == null) {
            this.compressingStream = new CompressedServletOutputStream((OutputStream)this.httpResponse.getOutputStream(), this.encodedStreamsFactory, this, this.threshold);
        }
        if (!this.compressingStream.isClosed() && this.mustNotCompress()) {
            this.compressingStream.cancelCompression();
        }
        return this.compressingStream;
    }

    private boolean mustNotCompress() {
        if (this.mimeIgnored) {
            LOGGER.trace("No Compression: Mime is ignored");
            return true;
        }
        if (this.savedContentLengthSet && this.savedContentLength < (long)this.threshold) {
            LOGGER.trace("No Compression: Already set content length {} less than threshold {}", new Object[]{this.savedContentLength, this.threshold});
            return true;
        }
        if (this.noTransformSet) {
            LOGGER.trace("No Compression: no-transform is set");
            return true;
        }
        return CompressedHttpServletResponseWrapper.alreadyCompressedEncoding(this.savedContentEncoding);
    }

    static {
        UNALLOWED_HEADERS.add("Content-Length".toLowerCase());
        UNALLOWED_HEADERS.add("Cache-Control".toLowerCase());
        UNALLOWED_HEADERS.add("Content-Encoding".toLowerCase());
        UNALLOWED_HEADERS.add("ETag".toLowerCase());
        LOGGER = LoggerFactory.getLogger((String)CompressedHttpServletResponseWrapper.class.getName());
    }
}

