/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.CompressedInput;
import com.googlecode.webutilities.filters.compression.CompressedOutput;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class GZIPEncodedStreamsFactory
extends EncodedStreamsFactory {
    GZIPEncodedStreamsFactory() {
    }

    @Override
    public CompressedOutput getCompressedStream(final OutputStream outputStream) throws IOException {
        return new CompressedOutput(){
            private final GZIPOutputStream gzipOutputStream;
            {
                this.gzipOutputStream = new GZIPOutputStream(outputStream);
            }

            @Override
            public OutputStream getCompressedOutputStream() {
                return this.gzipOutputStream;
            }

            @Override
            public void finish() throws IOException {
                this.gzipOutputStream.finish();
            }
        };
    }

    @Override
    public CompressedInput getCompressedStream(final InputStream inputStream) {
        return new CompressedInput(){

            @Override
            public InputStream getCompressedInputStream() throws IOException {
                return new GZIPInputStream(inputStream);
            }
        };
    }
}

