/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters;

import com.googlecode.webutilities.filters.common.AbstractFilter;
import com.googlecode.webutilities.util.Utils;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterEncodingFilter
extends AbstractFilter {
    private String encoding;
    private Boolean force = false;
    private static final String INIT_PARAM_ENCODING = "encoding";
    private static final String INIT_PARAM_FORCE = "force";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CharacterEncodingFilter.class.getName());

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.encoding = this.filterConfig.getInitParameter(INIT_PARAM_ENCODING);
        this.force = Utils.readBoolean(this.filterConfig.getInitParameter(INIT_PARAM_FORCE), this.force);
        LOGGER.debug("Filter initialized with: {}:{}, {}:{}", new Object[]{INIT_PARAM_ENCODING, this.encoding, INIT_PARAM_FORCE, this.force.toString()});
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String extensionOrFile;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String url = req.getRequestURI();
        if (this.isURLAccepted(url) && this.isUserAgentAccepted(req.getHeader("User-Agent")) && (this.force.booleanValue() || request.getCharacterEncoding() == null) && this.encoding != null) {
            request.setCharacterEncoding(this.encoding);
            LOGGER.debug("Applied request encoding : {}", (Object)this.encoding);
        }
        if ((extensionOrFile = Utils.detectExtension(url)) == null) {
            List<String> resources = Utils.findResourcesToMerge(req.getContextPath(), url);
            extensionOrFile = resources.get(0);
        }
        String mime = Utils.selectMimeForExtension(extensionOrFile);
        LOGGER.trace("Predicted output mime : {} for URL: {} ", new Object[]{mime, url});
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        if (this.encoding != null && this.force.booleanValue() && this.isMIMEAccepted(mime)) {
            try {
                resp.setCharacterEncoding(this.encoding);
                LOGGER.debug("Applied response encoding : {}", (Object)this.encoding);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set response encoding : {}", (Object)this.encoding);
            }
        }
    }
}

