/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.common;

import com.googlecode.webutilities.filters.common.IgnoreAcceptContext;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilter
implements Filter,
IgnoreAcceptContext {
    protected FilterConfig filterConfig;
    private String ignoreURLPattern;
    private String acceptURLPattern;
    private String ignoreMIMEPattern;
    private String acceptMIMEPattern;
    private String ignoreUAPattern;
    private String acceptUAPattern;
    private static final String INIT_PARAM_IGNORE_URL_PATTERN = "ignoreURLPattern";
    private static final String INIT_PARAM_ACCEPT_URL_PATTERN = "acceptURLPattern";
    private static final String INIT_PARAM_IGNORE_MIME_PATTERN = "ignoreMIMEPattern";
    private static final String INIT_PARAM_ACCEPT_MIME_PATTERN = "acceptMIMEPattern";
    private static final String INIT_PARAM_IGNORE_UA_PATTERN = "ignoreUAPattern";
    private static final String INIT_PARAM_ACCEPT_UA_PATTERN = "acceptUAPattern";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug("Initializing...");
        this.filterConfig = filterConfig;
        this.ignoreURLPattern = filterConfig.getInitParameter(INIT_PARAM_IGNORE_URL_PATTERN);
        this.acceptURLPattern = filterConfig.getInitParameter(INIT_PARAM_ACCEPT_URL_PATTERN);
        this.ignoreMIMEPattern = filterConfig.getInitParameter(INIT_PARAM_IGNORE_MIME_PATTERN);
        this.acceptMIMEPattern = filterConfig.getInitParameter(INIT_PARAM_ACCEPT_MIME_PATTERN);
        this.ignoreUAPattern = filterConfig.getInitParameter(INIT_PARAM_IGNORE_UA_PATTERN);
        this.acceptUAPattern = filterConfig.getInitParameter(INIT_PARAM_ACCEPT_UA_PATTERN);
        LOGGER.debug("Abstract Filter initialized with: {\n\t{}:{},\n\t{}:{},\n\t{}:{},\n\t{}:{}\n\t{}:{},\n\t{}:{}\n}", new Object[]{INIT_PARAM_IGNORE_URL_PATTERN, this.ignoreURLPattern, INIT_PARAM_ACCEPT_URL_PATTERN, this.acceptURLPattern, INIT_PARAM_IGNORE_MIME_PATTERN, this.acceptMIMEPattern, INIT_PARAM_ACCEPT_MIME_PATTERN, this.ignoreMIMEPattern, INIT_PARAM_IGNORE_UA_PATTERN, this.ignoreUAPattern, INIT_PARAM_ACCEPT_UA_PATTERN, this.acceptUAPattern});
    }

    private boolean isURLIgnored(String url) {
        return this.ignoreURLPattern != null && url != null && url.matches(this.ignoreURLPattern);
    }

    @Override
    public boolean isURLAccepted(String url) {
        return !this.isURLIgnored(url) && (this.acceptURLPattern == null || url != null && url.matches(this.acceptURLPattern));
    }

    private boolean isMIMEIgnored(String mimeType) {
        return this.ignoreMIMEPattern != null && mimeType != null && mimeType.matches(this.ignoreMIMEPattern);
    }

    @Override
    public boolean isMIMEAccepted(String mimeType) {
        return !this.isMIMEIgnored(mimeType) && (this.acceptMIMEPattern == null || mimeType != null && mimeType.matches(this.acceptMIMEPattern));
    }

    private boolean isUserAgentIgnored(String userAgent) {
        return this.ignoreUAPattern != null && userAgent != null && userAgent.matches(this.ignoreUAPattern);
    }

    @Override
    public boolean isUserAgentAccepted(String userAgent) {
        return !this.isUserAgentIgnored(userAgent) && (this.acceptUAPattern == null || userAgent != null && userAgent.matches(this.acceptUAPattern));
    }

    public void destroy() {
        LOGGER.debug("destroying...");
        this.filterConfig = null;
    }
}

