/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.CompressedServletInputStream;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public final class CompressedHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final HttpServletRequest request;
    private final EncodedStreamsFactory encodedStreamsFactory;
    private CompressedServletInputStream compressedStream;
    private BufferedReader bufferedReader;
    private boolean getInputStreamCalled;
    private boolean getReaderCalled;

    public CompressedHttpServletRequestWrapper(HttpServletRequest request, EncodedStreamsFactory encodedStreamsFactory) {
        super(request);
        this.request = request;
        this.encodedStreamsFactory = encodedStreamsFactory;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.getReaderCalled) {
            throw new IllegalStateException("getReader() has been already called");
        }
        this.getInputStreamCalled = true;
        return this.getCompressedServletInputStream();
    }

    public BufferedReader getReader() throws IOException {
        if (this.getInputStreamCalled) {
            throw new IllegalStateException("getInputStream() has been already called");
        }
        this.getReaderCalled = true;
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.getCompressedServletInputStream()), this.getCharacterEncoding()));
        }
        return this.bufferedReader;
    }

    private CompressedServletInputStream getCompressedServletInputStream() throws IOException {
        if (this.compressedStream == null) {
            this.compressedStream = new CompressedServletInputStream((InputStream)this.request.getInputStream(), this.encodedStreamsFactory);
        }
        return this.compressedStream;
    }

    private static boolean skippedHeader(String headerName) {
        return "Accept-Encoding".equalsIgnoreCase(headerName) || "Content-Encoding".equalsIgnoreCase(headerName);
    }

    public String getHeader(String header) {
        return CompressedHttpServletRequestWrapper.skippedHeader(header) ? null : super.getHeader(header);
    }

    public Enumeration<?> getHeaders(String header) {
        Enumeration original = super.getHeaders(header);
        if (original == null) {
            return null;
        }
        return CompressedHttpServletRequestWrapper.skippedHeader(header) ? Collections.enumeration(Collections.emptyList()) : original;
    }

    public long getDateHeader(String header) {
        return CompressedHttpServletRequestWrapper.skippedHeader(header) ? -1L : super.getDateHeader(header);
    }

    public int getIntHeader(String header) {
        return CompressedHttpServletRequestWrapper.skippedHeader(header) ? -1 : super.getIntHeader(header);
    }

    public Enumeration<?> getHeaderNames() {
        Enumeration originalHeaderNames = super.getHeaderNames();
        if (originalHeaderNames == null) {
            return null;
        }
        ArrayList<String> headerNames = new ArrayList<String>();
        while (originalHeaderNames.hasMoreElements()) {
            String headerName = (String)originalHeaderNames.nextElement();
            if (CompressedHttpServletRequestWrapper.skippedHeader(headerName)) continue;
            headerNames.add(headerName);
        }
        return Collections.enumeration(headerNames);
    }
}

