/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

final class CompressedServletInputStream
extends ServletInputStream {
    private final InputStream compressedStream;
    private boolean closed;

    CompressedServletInputStream(InputStream inputStream, EncodedStreamsFactory encodedStreamsFactory) throws IOException {
        this.compressedStream = encodedStreamsFactory.getCompressedStream(inputStream).getCompressedInputStream();
    }

    public int read() throws IOException {
        this.assertOpen();
        return this.compressedStream.read();
    }

    public int read(byte[] b) throws IOException {
        this.assertOpen();
        return this.compressedStream.read(b);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        this.assertOpen();
        return this.compressedStream.read(b, offset, length);
    }

    public long skip(long n) throws IOException {
        this.assertOpen();
        return this.compressedStream.skip(n);
    }

    public int available() throws IOException {
        this.assertOpen();
        return this.compressedStream.available();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.compressedStream.close();
            this.closed = true;
        }
    }

    public synchronized void mark(int limit) {
        this.assertOpen();
        this.compressedStream.mark(limit);
    }

    public synchronized void reset() throws IOException {
        this.assertOpen();
        this.compressedStream.reset();
    }

    public boolean markSupported() {
        this.assertOpen();
        return this.compressedStream.markSupported();
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Stream has been already closed.");
        }
    }
}

