/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.CompressedInput;
import com.googlecode.webutilities.filters.compression.CompressedOutput;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;

class DeflateEncodedStreamsFactory
extends EncodedStreamsFactory {
    DeflateEncodedStreamsFactory() {
    }

    @Override
    public CompressedOutput getCompressedStream(final OutputStream outputStream) {
        return new CompressedOutput(){
            private final DeflaterOutputStream deflaterOutputStream;
            {
                this.deflaterOutputStream = new DeflaterOutputStream(outputStream);
            }

            @Override
            public OutputStream getCompressedOutputStream() {
                return this.deflaterOutputStream;
            }

            @Override
            public void finish() throws IOException {
                this.deflaterOutputStream.finish();
            }
        };
    }

    @Override
    public CompressedInput getCompressedStream(final InputStream inputStream) {
        return new CompressedInput(){

            @Override
            public InputStream getCompressedInputStream() throws IOException {
                return new DeflaterInputStream(inputStream);
            }
        };
    }
}

