/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.filters.compression;

import com.googlecode.webutilities.filters.compression.CompressedInput;
import com.googlecode.webutilities.filters.compression.CompressedOutput;
import com.googlecode.webutilities.filters.compression.EncodedStreamsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class ZIPEncodedStreamsFactory
extends EncodedStreamsFactory {
    ZIPEncodedStreamsFactory() {
    }

    @Override
    public CompressedOutput getCompressedStream(final OutputStream outputStream) throws IOException {
        return new CompressedOutput(){
            private final ZipOutputStream zipOutputStream;
            boolean entryAdded;
            {
                this.zipOutputStream = new ZipOutputStream(outputStream);
                this.entryAdded = false;
            }

            @Override
            public OutputStream getCompressedOutputStream() {
                if (!this.entryAdded) {
                    try {
                        ZipEntry entry = new ZipEntry("compressed-response.out");
                        this.zipOutputStream.putNextEntry(entry);
                        this.entryAdded = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return this.zipOutputStream;
            }

            @Override
            public void finish() throws IOException {
                if (this.entryAdded) {
                    this.zipOutputStream.closeEntry();
                }
                this.zipOutputStream.finish();
            }
        };
    }

    @Override
    public CompressedInput getCompressedStream(final InputStream inputStream) {
        return new CompressedInput(){

            @Override
            public InputStream getCompressedInputStream() throws IOException {
                return new ZipInputStream(inputStream);
            }
        };
    }
}

