/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.servlets;

import com.googlecode.webutilities.common.Constants;
import com.googlecode.webutilities.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSCSSMergeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String INIT_PARAM_EXPIRES_MINUTES = "expiresMinutes";
    public static final String INIT_PARAM_CACHE_CONTROL = "cacheControl";
    public static final String INIT_PARAM_AUTO_CORRECT_URLS_IN_CSS = "autoCorrectUrlsInCSS";
    public static final String INIT_PARAM_TURN_OFF_E_TAG = "turnOffETag";
    public static final String INIT_PARAM_TURN_OFF_URL_FINGERPRINTING = "turnOffUrlFingerPrinting";
    public static final String INIT_PARAM_CUSTOM_CONTEXT_PATH_FOR_CSS_URLS = "customContextPathForCSSUrls";
    private long expiresMinutes = 10080L;
    private String cacheControl = "public";
    private boolean autoCorrectUrlsInCSS = true;
    private boolean turnOffETag = false;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JSCSSMergeServlet.class.getName());
    private String customContextPathForCSSUrls;
    private boolean turnOffUrlFingerPrinting = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.expiresMinutes = Utils.readLong(config.getInitParameter(INIT_PARAM_EXPIRES_MINUTES), this.expiresMinutes);
        this.cacheControl = config.getInitParameter(INIT_PARAM_CACHE_CONTROL) != null ? config.getInitParameter(INIT_PARAM_CACHE_CONTROL) : this.cacheControl;
        this.autoCorrectUrlsInCSS = Utils.readBoolean(config.getInitParameter(INIT_PARAM_AUTO_CORRECT_URLS_IN_CSS), this.autoCorrectUrlsInCSS);
        this.turnOffETag = Utils.readBoolean(config.getInitParameter(INIT_PARAM_TURN_OFF_E_TAG), this.turnOffETag);
        this.turnOffUrlFingerPrinting = Utils.readBoolean(config.getInitParameter(INIT_PARAM_TURN_OFF_URL_FINGERPRINTING), this.turnOffUrlFingerPrinting);
        this.customContextPathForCSSUrls = config.getInitParameter(INIT_PARAM_CUSTOM_CONTEXT_PATH_FOR_CSS_URLS);
        LOGGER.debug("Servlet initialized: {\n\t{}:{},\n\t{}:{},\n\t{}:{},\n\t{}:{}\n\t{}:{}\n}", new Object[]{INIT_PARAM_EXPIRES_MINUTES, String.valueOf(this.expiresMinutes), INIT_PARAM_CACHE_CONTROL, this.cacheControl, INIT_PARAM_AUTO_CORRECT_URLS_IN_CSS, String.valueOf(this.autoCorrectUrlsInCSS), INIT_PARAM_TURN_OFF_E_TAG, String.valueOf(this.turnOffETag), INIT_PARAM_TURN_OFF_URL_FINGERPRINTING, String.valueOf(this.turnOffUrlFingerPrinting)});
    }

    private void addAppropriateResponseHeaders(String extensionOrFile, List<String> resourcesToMerge, String hashForETag, HttpServletResponse resp) {
        String mime = Utils.selectMimeForExtension(extensionOrFile);
        if (mime != null) {
            LOGGER.trace("Setting MIME to {}", (Object)mime);
            resp.setContentType(mime);
        }
        long lastModifiedFor = Utils.getLastModifiedFor(resourcesToMerge, this.getServletContext());
        resp.addDateHeader("Expires", new Date().getTime() + this.expiresMinutes * 60L * 1000L);
        resp.addHeader("Cache-Control", this.cacheControl);
        resp.addDateHeader("Last-Modified", lastModifiedFor);
        if (hashForETag != null && !this.turnOffETag) {
            resp.addHeader("ETag", hashForETag);
        }
        resp.addHeader("X-Optimized-By", "http://webutilities.googlecode.com");
        LOGGER.trace("Added expires, last-modified & ETag headers");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ResourceStatus status;
        String url = this.getURL(req);
        LOGGER.debug("Started processing request : {}", (Object)url);
        List<String> resourcesToMerge = Utils.findResourcesToMerge(req.getContextPath(), url);
        String extensionOrPath = Utils.detectExtension(url);
        if (extensionOrPath == null) {
            extensionOrPath = resourcesToMerge.get(0);
        }
        if ((status = JSCSSMergeServlet.isNotModified(this.getServletContext(), req, resourcesToMerge, this.turnOffETag)).isNotModified()) {
            LOGGER.trace("Resources Not Modified. Sending 304.");
            String ETag = !this.turnOffETag ? status.getActualETag() : null;
            JSCSSMergeServlet.sendNotModified(resp, extensionOrPath, ETag, this.expiresMinutes, this.cacheControl);
            return;
        }
        this.addAppropriateResponseHeaders(extensionOrPath, resourcesToMerge, status.getActualETag(), resp);
        ServletOutputStream outputStream = resp.getOutputStream();
        String contextPathForCss = this.customContextPathForCSSUrls != null ? this.customContextPathForCSSUrls : req.getContextPath();
        int resourcesNotFound = this.processResources(contextPathForCss, (OutputStream)outputStream, resourcesToMerge);
        if (resourcesNotFound > 0 && resourcesNotFound == resourcesToMerge.size()) {
            resp.sendError(404);
            LOGGER.warn("All resources are not found. Sending 404.");
            return;
        }
        if (outputStream != null) {
            try {
                resp.setStatus(200);
                outputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        LOGGER.debug("Finished processing Request : {}", (Object)url);
    }

    public static void sendNotModified(HttpServletResponse response, String extensionOrFile, String hashForETag, long expiresMinutes, String cacheControl) {
        response.setContentLength(0);
        response.setStatus(304);
        String mime = Utils.selectMimeForExtension(extensionOrFile);
        if (mime != null) {
            LOGGER.trace("Setting MIME to {}", (Object)mime);
            response.setContentType(mime);
        }
        response.addDateHeader("Expires", new Date().getTime() + expiresMinutes * 60L * 1000L);
        if (cacheControl != null) {
            response.addHeader("Cache-Control", cacheControl);
        }
        if (hashForETag != null) {
            response.addHeader("ETag", hashForETag);
        }
        response.addHeader("X-Optimized-By", "http://webutilities.googlecode.com");
        LOGGER.trace("Added expires, last-modified & ETag headers");
    }

    private String getURL(HttpServletRequest request) {
        return Utils.removeFingerPrint(request.getRequestURI());
    }

    public static ResourceStatus isNotModified(ServletContext context, HttpServletRequest request, List<String> resourcesToMerge, boolean turnOffETag) {
        String actualETag;
        Date date;
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && (date = Utils.readDateFromHeader(ifModifiedSince)) != null && !Utils.isAnyResourceModifiedSince(resourcesToMerge, date.getTime(), context)) {
            return new ResourceStatus(null, true);
        }
        String requestETag = request.getHeader("If-None-Match");
        String string = actualETag = turnOffETag ? null : Utils.buildETagForResources(resourcesToMerge, context);
        if (!turnOffETag && !Utils.isAnyResourceETagModified(resourcesToMerge, requestETag, actualETag, context)) {
            return new ResourceStatus(actualETag, true);
        }
        return new ResourceStatus(actualETag, false);
    }

    private int processResources(String contextPath, OutputStream outputStream, List<String> resourcesToMerge) {
        int resourcesNotFound = 0;
        ServletContext context = this.getServletContext();
        for (String resourcePath : resourcesToMerge) {
            LOGGER.trace("Processing resource : {}", (Object)resourcePath);
            InputStream is = null;
            try {
                is = context.getResourceAsStream(resourcePath);
                if (is == null) {
                    ++resourcesNotFound;
                    continue;
                }
                if (resourcePath.endsWith(".css") && this.autoCorrectUrlsInCSS) {
                    this.processCSS(contextPath, resourcePath, is, outputStream);
                } else {
                    int c;
                    byte[] buffer = new byte[128];
                    while ((c = is.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, c);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while reading resource : {}", (Object)resourcePath);
                LOGGER.error("IOException: ", (Throwable)e);
            }
            if (is == null) continue;
            try {
                is.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to close stream:", (Throwable)ex);
            }
            try {
                outputStream.flush();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to flush out: {}", (Object)outputStream);
            }
        }
        return resourcesNotFound;
    }

    private void processCSS(String contextPath, String cssFilePath, InputStream inputStream, OutputStream outputStream) throws IOException {
        String line;
        ServletContext context = this.getServletContext();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer buffer = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            buffer.setLength(0);
            buffer.append(line);
            line = this.processCSSLine(context, contextPath, cssFilePath, buffer);
            outputStream.write((line + "\n").getBytes());
        }
    }

    private String processCSSLine(ServletContext context, String contextPath, String cssFilePath, StringBuffer line) {
        Matcher matcher = Constants.CSS_IMG_URL_PATTERN.matcher(line);
        String cssRealPath = context.getRealPath(cssFilePath);
        while (matcher.find()) {
            String refImgPath = matcher.group(1);
            if (Utils.isProtocolURL(refImgPath)) continue;
            String resolvedImgPath = refImgPath;
            if (!refImgPath.startsWith("/")) {
                resolvedImgPath = Utils.buildProperPath(Utils.getParentPath(cssFilePath), refImgPath);
            }
            String imgRealPath = context.getRealPath(resolvedImgPath);
            int offset = line.indexOf(refImgPath);
            line.replace(offset, offset + refImgPath.length(), contextPath + (this.turnOffUrlFingerPrinting ? resolvedImgPath : Utils.addFingerPrint(Utils.buildETagForResource(resolvedImgPath, context), resolvedImgPath)));
            Utils.updateReferenceMap(cssRealPath, imgRealPath);
            matcher.reset(line.subSequence(offset + refImgPath.length(), line.length()));
        }
        return line.toString();
    }

    public static class ResourceStatus {
        private String actualETag;
        private boolean notModified = true;

        ResourceStatus(String actualETag, boolean notModified) {
            this.actualETag = actualETag;
            this.notModified = notModified;
        }

        public String getActualETag() {
            return this.actualETag;
        }

        public boolean isNotModified() {
            return this.notModified;
        }
    }
}

