/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.tags;

import com.googlecode.webutilities.util.Utils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private String value;
    private String context;
    private String var;
    private int scope = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)URLTag.class.getName());

    public void setVar(String var) {
        this.var = var;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        if (this.value == null || Utils.isProtocolURL(this.value.toLowerCase().trim())) {
            LOGGER.trace("Invalid url : {}", (Object)this.value);
            return this.gracefully();
        }
        if (this.context == null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            this.context = httpServletRequest.getContextPath();
        }
        if (!(this.context.startsWith("/") && this.value.startsWith("/") || !this.value.endsWith("/"))) {
            LOGGER.warn("Invalid context|value.");
            throw new JspTagException("Invalid context|value");
        }
        String eTag = Utils.buildETagForResources(Utils.findResourcesToMerge(this.context, this.value), this.pageContext.getServletContext());
        this.value = Utils.addFingerPrint(eTag, this.value);
        this.value = this.context + "/" + this.value;
        this.value = this.value.replaceAll("/+", "/");
        return this.gracefully();
    }

    private int gracefully() throws JspTagException {
        if (this.value != null) {
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, (Object)this.value, this.scope);
            } else {
                try {
                    this.pageContext.getOut().print(this.value);
                }
                catch (IOException ex) {
                    LOGGER.error("IO Error:", (Throwable)ex);
                    throw new JspTagException(ex.toString(), (Throwable)ex);
                }
            }
        }
        return 6;
    }
}

