/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webutilities.tags;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YUIMinTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private String charset = "UTF-8";
    private int lineBreak = -1;
    private boolean noMunge = false;
    private boolean preserveSemi = false;
    private boolean disableOptimizations = false;
    private String type;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)YUIMinTag.class.getName());

    public void setType(String type) {
        this.type = type;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (!Charset.isSupported(this.charset)) {
            LOGGER.warn("Charset {} not supported. Using default : ", (Object)this.charset, (Object)"UTF-8");
            this.charset = "UTF-8";
        }
    }

    public void setLineBreak(int lineBreak) {
        this.lineBreak = lineBreak;
    }

    public void setNoMunge(boolean noMunge) {
        this.noMunge = noMunge;
    }

    public void setPreserveSemi(boolean preserveSemi) {
        this.preserveSemi = preserveSemi;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public int doAfterBody() throws JspException {
        String stringContent;
        BodyContent content = this.getBodyContent();
        try {
            stringContent = new String(content.getString().getBytes(), this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            stringContent = content.getString();
            LOGGER.warn("Failed to parse contents using charset: {}", (Object)this.charset);
        }
        StringReader stringReader = new StringReader(stringContent);
        JspWriter jspWriter = content.getEnclosingWriter();
        try {
            if ("js".equals(this.type.toLowerCase())) {
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)stringReader, null);
                LOGGER.trace("Compressing {}", (Object)"js");
                compressor.compress((Writer)jspWriter, this.lineBreak, !this.noMunge, false, this.preserveSemi, this.disableOptimizations);
            } else if ("css".equals(this.type.toLowerCase())) {
                CssCompressor compressor = new CssCompressor((Reader)stringReader);
                LOGGER.trace("Compressing {}", (Object)"css");
                compressor.compress((Writer)jspWriter, this.lineBreak);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in YUIMinTag: ", (Throwable)e);
            return 1;
        }
        return 0;
    }
}

