/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.jackson.ColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.options.color.SimpleColor;
import java.io.IOException;

public class SimpleColorReferenceSerializer
extends ColorReferenceSerializer<SimpleColor> {
    @Override
    protected void serializeIfNotNull(SimpleColor color, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (color.getBrightness() == null) {
            jgen.writeString(this.toHexString(color.getColor()));
        } else {
            String colorString = this.brighten("\"" + this.toHexString(color.getColor()) + "\"", color.getBrightness().floatValue());
            jgen.writeRawValue(colorString);
        }
    }
}

