/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.string.StringValue;

public abstract class JavaScriptExpressionSendingAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private final Map<String, String> javascriptExpressions = new HashMap<String, String>();

    protected StringValue getVariableValue(String parameterName) {
        RequestCycle cycle = RequestCycle.get();
        WebRequest webRequest = (WebRequest)cycle.getRequest();
        StringValue value = webRequest.getQueryParameters().getParameterValue(parameterName);
        return value;
    }

    public CharSequence getCallbackScript() {
        String script = super.getCallbackScript().toString();
        for (String parameterName : this.javascriptExpressions.keySet()) {
            String expression = this.javascriptExpressions.get(parameterName);
            script = script.replace("\"" + expression + "\"", expression);
        }
        return script;
    }

    public void addJavaScriptValue(String parameterName, String javascriptExpression) {
        this.javascriptExpressions.put(parameterName, javascriptExpression);
    }

    public void addJavaScriptValues(Map<String, String> parameterMap) {
        for (String parameterName : parameterMap.keySet()) {
            this.javascriptExpressions.put(parameterName, parameterMap.get(parameterName));
        }
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        for (String parameterName : this.javascriptExpressions.keySet()) {
            attributes.getExtraParameters().put(parameterName, this.javascriptExpressions.get(parameterName));
        }
    }
}

