/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.selection;

import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.interaction.SelectionEvent;
import com.googlecode.wickedcharts.highcharts.options.interaction.SelectionFunction;
import com.googlecode.wickedcharts.highcharts.options.processing.IOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.wicket6.highcharts.Chart;
import com.googlecode.wickedcharts.wicket6.highcharts.features.selection.SelectionBehavior;
import com.googlecode.wickedcharts.wicket6.highcharts.features.selection.WicketSelectionEvent;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;

public class SelectionProcessor
implements IOptionsProcessor,
Serializable {
    private final Chart chart;

    public SelectionProcessor(Chart chart) {
        this.chart = chart;
    }

    public void processOptions(Options options, OptionsProcessorContext context) {
        List functions = context.getSelectionFunctions();
        for (final SelectionFunction function : functions) {
            SelectionBehavior selectionBehavior = new SelectionBehavior(){

                @Override
                public void onSelection(SelectionEvent event, AjaxRequestTarget target) {
                    WicketSelectionEvent wicketEvent = new WicketSelectionEvent(target, event);
                    function.onSelect((SelectionEvent)wicketEvent);
                }
            };
            this.chart.add(new Behavior[]{selectionBehavior});
            String functionBody = selectionBehavior.getCallbackScript().toString();
            function.setFunction(functionBody);
        }
    }
}

