/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.ServerAddressAware;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextVersionCommand
extends Command
implements ServerAddressAware {
    public InetSocketAddress server;

    public final InetSocketAddress getServer() {
        return this.server;
    }

    public final void setServer(InetSocketAddress server) {
        this.server = server;
    }

    public TextVersionCommand(CountDownLatch latch, InetSocketAddress server) {
        super("version", (byte[])null, latch);
        this.commandType = CommandType.VERSION;
        this.server = server;
    }

    public final boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        String line = ByteUtils.nextLine(buffer);
        if (line != null) {
            if (line.startsWith("VERSION")) {
                String[] items = line.split(" ");
                this.setResult(items.length > 1 ? items[1] : "unknown version");
                this.countDownLatch();
                return true;
            }
            return this.decodeError(line);
        }
        return false;
    }

    public final void encode() {
        this.ioBuffer = IoBuffer.wrap(VERSION.slice());
    }
}

