/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.impl.AbstractMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMemcachedSessionLocator
extends AbstractMemcachedSessionLocator {
    private HashAlgorithm hashAlgorighm;
    private volatile transient List<Session> sessions;

    public ArrayMemcachedSessionLocator() {
        this.hashAlgorighm = HashAlgorithm.NATIVE_HASH;
    }

    public ArrayMemcachedSessionLocator(HashAlgorithm hashAlgorighm) {
        this.hashAlgorighm = hashAlgorighm;
    }

    public final void setHashAlgorighm(HashAlgorithm hashAlgorighm) {
        this.hashAlgorighm = hashAlgorighm;
    }

    public final long getHash(int size, String key) {
        long hash = this.hashAlgorighm.hash(key);
        return hash % (long)size;
    }

    @Override
    public final Session getSessionByKey(String key) {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        List<Session> sessionList = this.sessions;
        int size = sessionList.size();
        if (size == 0) {
            return null;
        }
        long start = this.getHash(size, key);
        Session session = sessionList.get((int)start);
        if (!this.failureMode && (session == null || session.isClosed())) {
            long next = this.getNext(size, start);
            while ((session == null || session.isClosed()) && next != start) {
                session = sessionList.get((int)next);
                next = this.getNext(size, next);
            }
        }
        return session;
    }

    public final long getNext(int size, long start) {
        if (start == (long)(size - 1)) {
            return 0L;
        }
        return start + 1L;
    }

    @Override
    public final void updateSessions(Collection<Session> list) {
        Collection<Session> copySessions = list;
        ArrayList<Session> newSessions = new ArrayList<Session>(copySessions.size() * 2);
        for (Session session : copySessions) {
            if (session instanceof MemcachedTCPSession) {
                int weight = ((MemcachedSession)session).getWeight();
                for (int i = 0; i < weight; ++i) {
                    newSessions.add(session);
                }
                continue;
            }
            newSessions.add(session);
        }
        this.sessions = newSessions;
    }
}

