/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSerializingTranscoder {
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 16384;
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected int compressionThreshold = 16384;
    protected String charset = "UTF-8";
    protected static final Logger log = LoggerFactory.getLogger(BaseSerializingTranscoder.class);

    public void setCompressionThreshold(int to) {
        this.compressionThreshold = to;
    }

    public void setCharset(String to) {
        try {
            new String(new byte[97], to);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.charset = to;
    }

    protected byte[] serialize(Object o) {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserialize(byte[] in) {
        Object rv = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
            }
        }
        catch (IOException e) {
            log.error("Caught IOException decoding " + in.length + " bytes of data", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("Caught CNFE decoding " + in.length + " bytes of data", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
        return rv;
    }

    public static final byte[] compress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            if (gz != null) {
                try {
                    gz.close();
                }
                catch (IOException e) {
                    log.error("Close GZIPOutputStream error", (Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error("Close ByteArrayOutputStream error", (Throwable)e);
                }
            }
        }
        byte[] rv = bos.toByteArray();
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            GZIPInputStream gis = null;
            try {
                gis = new GZIPInputStream(bis);
                byte[] buf = new byte[16384];
                int r = -1;
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                log.error("Failed to decompress data", (Throwable)e);
                bos = null;
            }
            finally {
                if (gis != null) {
                    try {
                        gis.close();
                    }
                    catch (IOException e) {
                        log.error("Close GZIPInputStream error", (Throwable)e);
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        log.error("Close ByteArrayInputStream error", (Throwable)e);
                    }
                }
            }
        }
        return bos == null ? null : bos.toByteArray();
    }

    protected String decodeString(byte[] data) {
        String rv = null;
        try {
            if (data != null) {
                rv = new String(data, this.charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return rv;
    }

    protected byte[] encodeString(String in) {
        byte[] rv = null;
        try {
            rv = in.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return rv;
    }
}

