/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.PrimitiveTypeTranscoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerTranscoder
extends PrimitiveTypeTranscoder<Integer> {
    @Override
    public CachedData encode(Integer l) {
        if (this.primitiveAsString) {
            byte[] b = this.encodeString(l.toString());
            int flags = 0;
            if (b.length > this.compressionThreshold) {
                byte[] compressed = IntegerTranscoder.compress(b);
                if (compressed.length < b.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Compressed " + l.getClass().getName() + " from " + b.length + " to " + compressed.length);
                    }
                    b = compressed;
                    flags |= 2;
                } else if (log.isDebugEnabled()) {
                    log.debug("Compression increased the size of " + l.getClass().getName() + " from " + b.length + " to " + compressed.length);
                }
            }
            return new CachedData(flags, b, b.length, -1L);
        }
        return new CachedData(512, this.tu.encodeInt(l));
    }

    @Override
    public Integer decode(CachedData d) {
        if (this.primitiveAsString) {
            int flag;
            byte[] data = d.getData();
            if ((d.getFlag() & 2) != 0) {
                data = this.decompress(d.getData());
            }
            if ((flag = d.getFlag()) == 0) {
                return Integer.valueOf(this.decodeString(data));
            }
            return null;
        }
        if (512 == d.getFlag()) {
            return this.tu.decodeInt(d.getData());
        }
        return null;
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    @Override
    public void setPackZeros(boolean packZeros) {
        this.tu.setPackZeros(packZeros);
    }
}

