/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.PrimitiveTypeTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongTranscoder
extends PrimitiveTypeTranscoder<Long> {
    private static final Logger log = LoggerFactory.getLogger(LongTranscoder.class);

    @Override
    public CachedData encode(Long l) {
        if (this.primitiveAsString) {
            byte[] b = this.encodeString(l.toString());
            int flags = 0;
            if (b.length > this.compressionThreshold) {
                byte[] compressed = LongTranscoder.compress(b);
                if (compressed.length < b.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Compressed " + l.getClass().getName() + " from " + b.length + " to " + compressed.length);
                    }
                    b = compressed;
                    flags |= 2;
                } else if (log.isDebugEnabled()) {
                    log.debug("Compression increased the size of " + l.getClass().getName() + " from " + b.length + " to " + compressed.length);
                }
            }
            return new CachedData(flags, b, b.length, -1L);
        }
        return new CachedData(768, this.tu.encodeLong(l));
    }

    @Override
    public Long decode(CachedData d) {
        if (this.primitiveAsString) {
            int flag;
            byte[] data = d.getData();
            if ((d.getFlag() & 2) != 0) {
                data = this.decompress(d.getData());
            }
            if ((flag = d.getFlag()) == 0) {
                return Long.valueOf(this.decodeString(data));
            }
            return null;
        }
        if (768 == d.getFlag()) {
            return this.tu.decodeLong(d.getData());
        }
        log.error("Unexpected flags for long:  " + d.getFlag() + " wanted " + 768);
        return null;
    }
}

