/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import java.util.Date;
import net.rubyeye.xmemcached.transcoders.BaseSerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.transcoders.TranscoderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingTranscoder
extends BaseSerializingTranscoder
implements Transcoder<Object> {
    private final int maxSize;
    private boolean primitiveAsString;
    public static final int SERIALIZED = 1;
    public static final int COMPRESSED = 2;
    public static final int SPECIAL_MASK = 65280;
    public static final int SPECIAL_BOOLEAN = 256;
    public static final int SPECIAL_INT = 512;
    public static final int SPECIAL_LONG = 768;
    public static final int SPECIAL_DATE = 1024;
    public static final int SPECIAL_BYTE = 1280;
    public static final int SPECIAL_FLOAT = 1536;
    public static final int SPECIAL_DOUBLE = 1792;
    public static final int SPECIAL_BYTEARRAY = 2048;
    private final TranscoderUtils transcoderUtils = new TranscoderUtils(true);

    @Override
    public void setPackZeros(boolean packZeros) {
        this.transcoderUtils.setPackZeros(packZeros);
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public TranscoderUtils getTranscoderUtils() {
        return this.transcoderUtils;
    }

    public SerializingTranscoder() {
        this(CachedData.MAX_SIZE);
    }

    public SerializingTranscoder(int max) {
        this.maxSize = max;
    }

    @Override
    public boolean isPackZeros() {
        return this.transcoderUtils.isPackZeros();
    }

    @Override
    public boolean isPrimitiveAsString() {
        return this.primitiveAsString;
    }

    @Override
    public final Object decode(CachedData d) {
        byte[] data = d.getData();
        int flags = d.getFlag();
        if ((flags & 2) != 0) {
            data = this.decompress(d.getData());
        }
        return this.decode0(d, data, flags &= 0xFF00);
    }

    protected final Object decode0(CachedData cachedData, byte[] data, int flags) {
        Object rv = null;
        if ((cachedData.getFlag() & 1) != 0 && data != null) {
            rv = this.deserialize(data);
        } else {
            if (this.primitiveAsString && flags == 0) {
                return this.decodeString(data);
            }
            if (flags != 0 && data != null) {
                switch (flags) {
                    case 256: {
                        rv = this.transcoderUtils.decodeBoolean(data);
                        break;
                    }
                    case 512: {
                        rv = this.transcoderUtils.decodeInt(data);
                        break;
                    }
                    case 768: {
                        rv = this.transcoderUtils.decodeLong(data);
                        break;
                    }
                    case 1280: {
                        rv = this.transcoderUtils.decodeByte(data);
                        break;
                    }
                    case 1536: {
                        rv = new Float(Float.intBitsToFloat(this.transcoderUtils.decodeInt(data)));
                        break;
                    }
                    case 1792: {
                        rv = new Double(Double.longBitsToDouble(this.transcoderUtils.decodeLong(data)));
                        break;
                    }
                    case 1024: {
                        rv = new Date(this.transcoderUtils.decodeLong(data));
                        break;
                    }
                    case 2048: {
                        rv = data;
                        break;
                    }
                    default: {
                        log.warn(String.format("Undecodeable with flags %x", flags));
                        break;
                    }
                }
            } else {
                rv = this.decodeString(data);
            }
        }
        return rv;
    }

    @Override
    public final CachedData encode(Object o) {
        byte[] b = null;
        int flags = 0;
        if (o instanceof String) {
            b = this.encodeString((String)o);
        } else if (o instanceof Long) {
            b = this.primitiveAsString ? this.encodeString(o.toString()) : this.transcoderUtils.encodeLong((Long)o);
            flags |= 0x300;
        } else if (o instanceof Integer) {
            b = this.primitiveAsString ? this.encodeString(o.toString()) : this.transcoderUtils.encodeInt((Integer)o);
            flags |= 0x200;
        } else if (o instanceof Boolean) {
            b = this.primitiveAsString ? this.encodeString(o.toString()) : this.transcoderUtils.encodeBoolean((Boolean)o);
            flags |= 0x100;
        } else if (o instanceof Date) {
            b = this.transcoderUtils.encodeLong(((Date)o).getTime());
            flags |= 0x400;
        } else if (o instanceof Byte) {
            b = this.primitiveAsString ? this.encodeString(o.toString()) : this.transcoderUtils.encodeByte((Byte)o);
            flags |= 0x500;
        } else if (o instanceof Float) {
            b = this.primitiveAsString ? this.encodeString(o.toString()) : this.transcoderUtils.encodeInt(Float.floatToRawIntBits(((Float)o).floatValue()));
            flags |= 0x600;
        } else if (o instanceof Double) {
            b = this.primitiveAsString ? this.encodeString(o.toString()) : this.transcoderUtils.encodeLong(Double.doubleToRawLongBits((Double)o));
            flags |= 0x700;
        } else if (o instanceof byte[]) {
            b = (byte[])o;
            flags |= 0x800;
        } else {
            b = this.serialize(o);
            flags |= 1;
        }
        assert (b != null);
        if (this.primitiveAsString && !(flags & true)) {
            flags = 0;
        }
        if (b.length > this.compressionThreshold) {
            byte[] compressed = SerializingTranscoder.compress(b);
            if (compressed.length < b.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Compressed " + o.getClass().getName() + " from " + b.length + " to " + compressed.length);
                }
                b = compressed;
                flags |= 2;
            } else if (log.isDebugEnabled()) {
                log.debug("Compression increased the size of " + o.getClass().getName() + " from " + b.length + " to " + compressed.length);
            }
        }
        return new CachedData(flags, b, this.maxSize, -1L);
    }
}

