/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import net.rubyeye.xmemcached.exception.MemcachedDecodeException;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokyoTyrantTranscoder
implements Transcoder<Object> {
    private final SerializingTranscoder serializingTranscoder;

    public TokyoTyrantTranscoder(int maxSize) {
        this.serializingTranscoder = new SerializingTranscoder(maxSize);
        this.serializingTranscoder.setPackZeros(false);
    }

    public TokyoTyrantTranscoder() {
        this.serializingTranscoder = new SerializingTranscoder();
        this.serializingTranscoder.setPackZeros(false);
    }

    @Override
    public final Object decode(CachedData d) {
        byte[] compositeData = d.getData();
        if (compositeData.length <= 4) {
            throw new MemcachedDecodeException("There are no four bytes before value for TokyoTyrantTranscoder");
        }
        byte[] flagBytes = new byte[4];
        byte[] realData = new byte[compositeData.length - 4];
        System.arraycopy(compositeData, 0, flagBytes, 0, 4);
        System.arraycopy(compositeData, 4, realData, 0, compositeData.length - 4);
        int flag = this.serializingTranscoder.getTranscoderUtils().decodeInt(flagBytes);
        d.setFlag(flag);
        if ((flag & 2) != 0) {
            realData = this.serializingTranscoder.decompress(realData);
        }
        return this.serializingTranscoder.decode0(d, realData, flag &= 0xFF00);
    }

    @Override
    public final CachedData encode(Object o) {
        CachedData result = this.serializingTranscoder.encode(o);
        byte[] realData = result.getData();
        int flag = result.getFlag();
        byte[] flagBytes = this.serializingTranscoder.getTranscoderUtils().encodeInt(flag);
        byte[] compisiteData = new byte[4 + realData.length];
        System.arraycopy(flagBytes, 0, compisiteData, 0, 4);
        System.arraycopy(realData, 0, compisiteData, 4, realData.length);
        result.setData(compisiteData);
        return result;
    }

    public final int getMaxSize() {
        return this.serializingTranscoder.getMaxSize();
    }

    @Override
    public boolean isPackZeros() {
        return this.serializingTranscoder.isPackZeros();
    }

    @Override
    public boolean isPrimitiveAsString() {
        return this.serializingTranscoder.isPrimitiveAsString();
    }

    public void setCharset(String to) {
        this.serializingTranscoder.setCharset(to);
    }

    @Override
    public void setCompressionThreshold(int to) {
        this.serializingTranscoder.setCompressionThreshold(to);
    }

    @Override
    public void setPackZeros(boolean packZeros) {
        throw new UnsupportedOperationException("TokyoTyrantTranscoder doesn't support pack zeros");
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        throw new UnsupportedOperationException("TokyoTyrantTranscoder doesn't support save primitive type as String");
    }
}

