/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.rubyeye.xmemcached.codec.MemcachedDecoder;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.utils.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteUtils {
    public static final Logger log = LoggerFactory.getLogger(ByteUtils.class);
    public static final String DEFAULT_CHARSET_NAME = "utf-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    public static final ByteBuffer SPLIT = ByteBuffer.wrap(Constants.CRLF);
    public static boolean testing;
    private static Protocol memcachedProtocol;
    private static int maxKeyLength;
    static final byte[] digits;
    static final byte[] DigitTens;
    static final byte[] DigitOnes;
    static final int[] sizeTable;
    static final int[] byte_len_array;

    private ByteUtils() {
    }

    public static final byte[] getBytes(String k) {
        if (k == null || k.length() == 0) {
            throw new IllegalArgumentException("Key must not be blank");
        }
        try {
            return k.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void setArguments(IoBuffer bb, Object ... args) {
        boolean wasFirst = true;
        for (Object o : args) {
            if (wasFirst) {
                wasFirst = false;
            } else {
                bb.put((byte)32);
            }
            if (o instanceof byte[]) {
                bb.put((byte[])o);
                continue;
            }
            bb.put(ByteUtils.getBytes(String.valueOf(o)));
        }
        bb.put(Constants.CRLF);
    }

    public static final int setArguments(byte[] bb, int index, Object ... args) {
        boolean wasFirst = true;
        int s = index;
        for (Object o : args) {
            if (wasFirst) {
                wasFirst = false;
            } else {
                bb[s++] = 32;
            }
            if (o instanceof byte[]) {
                byte[] tmp = (byte[])o;
                System.arraycopy(tmp, 0, bb, s, tmp.length);
                s += tmp.length;
                continue;
            }
            if (o instanceof Integer) {
                int v = (Integer)o;
                ByteUtils.getBytes(v, s += ByteUtils.stringSize(v), bb);
                continue;
            }
            if (o instanceof String) {
                byte[] tmp = ByteUtils.getBytes((String)o);
                System.arraycopy(tmp, 0, bb, s, tmp.length);
                s += tmp.length;
                continue;
            }
            if (!(o instanceof Long)) continue;
            long v = (Long)o;
            ByteUtils.getBytes(v, s += ByteUtils.stringSize(v), bb);
        }
        System.arraycopy(Constants.CRLF, 0, bb, s, 2);
        return s += 2;
    }

    public static final void checkKey(byte[] keyBytes) {
        if (keyBytes.length > maxKeyLength) {
            throw new IllegalArgumentException("Key is too long (maxlen = " + maxKeyLength + ")");
        }
        if (memcachedProtocol == Protocol.Text || testing) {
            for (byte b : keyBytes) {
                if (b != 32 && b != 10 && b != 13 && b != 0) continue;
                try {
                    throw new IllegalArgumentException("Key contains invalid characters:  ``" + new String(keyBytes, DEFAULT_CHARSET_NAME) + "''");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
    }

    public static final void checkKey(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Key must not be blank");
        }
        byte[] keyBytes = ByteUtils.getBytes(key);
        if (keyBytes.length > maxKeyLength) {
            throw new IllegalArgumentException("Key is too long (maxlen = " + maxKeyLength + ")");
        }
        if (memcachedProtocol == Protocol.Text || testing) {
            for (byte b : keyBytes) {
                if (b != 32 && b != 10 && b != 13 && b != 0) continue;
                try {
                    throw new IllegalArgumentException("Key contains invalid characters:\"" + new String(keyBytes, DEFAULT_CHARSET_NAME) + "\"");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void setProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("Null Protocol");
        }
        memcachedProtocol = protocol;
        maxKeyLength = protocol == Protocol.Text ? 250 : 65535;
    }

    public static final int normalizeCapacity(int requestedCapacity) {
        switch (requestedCapacity) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: 
            case 0x200000: 
            case 0x400000: 
            case 0x800000: 
            case 0x1000000: 
            case 0x2000000: 
            case 0x4000000: 
            case 0x8000000: 
            case 0x10000000: 
            case 0x20000000: 
            case 0x40000000: 
            case 0x7FFFFFFF: {
                return requestedCapacity;
            }
        }
        int newCapacity = 1;
        while (newCapacity < requestedCapacity) {
            if ((newCapacity <<= 1) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return newCapacity;
    }

    public static final boolean stepBuffer(ByteBuffer buffer, int remaining) {
        if (buffer.remaining() >= remaining) {
            buffer.position(buffer.position() + remaining);
            return true;
        }
        return false;
    }

    public static final String nextLine(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        int index = MemcachedDecoder.SPLIT_MATCHER.matchFirst(IoBuffer.wrap(buffer));
        if (index >= 0) {
            int limit = buffer.limit();
            buffer.limit(index);
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            buffer.limit(limit);
            buffer.position(index + SPLIT.remaining());
            return ByteUtils.getString(bytes);
        }
        return null;
    }

    public static String getString(byte[] bytes) {
        try {
            return new String(bytes, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    public static void int2hex(int a, StringBuffer str) {
        str.append(Integer.toHexString(a));
    }

    public static void short2hex(int a, StringBuffer str) {
        str.append(Integer.toHexString(a));
    }

    public static void getBytes(long i, int index, byte[] buf) {
        int q2;
        int r;
        int pos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--pos] = DigitOnes[r];
            buf[--pos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--pos] = DigitOnes[r];
            buf[--pos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--pos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--pos] = sign;
        }
    }

    static void getBytes(int i, int index, byte[] buf) {
        int r;
        int q;
        int pos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--pos] = DigitOnes[r];
            buf[--pos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--pos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--pos] = sign;
        }
    }

    public static final int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static final int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    static {
        memcachedProtocol = Protocol.Text;
        maxKeyLength = 250;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
        DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        byte_len_array = new int[256];
        for (int i = -128; i <= 127; ++i) {
            int size;
            ByteUtils.byte_len_array[i & 0xFF] = size = i < 0 ? ByteUtils.stringSize(-i) + 1 : ByteUtils.stringSize(i);
        }
    }
}

