/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils.hibernate;

import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheClientFactory;
import com.googlecode.hibernate.memcached.PropertiesHelper;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.utils.AddrUtil;
import net.rubyeye.xmemcached.utils.hibernate.Xmemcache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmemcachedClientFactory
implements MemcacheClientFactory {
    public static final String PROP_SERVERS = "hibernate.memcached.servers";
    public static final String PROP_READ_BUFFER_SIZE = "hibernate.memcached.readBufferSize";
    public static final String PROP_OPERATION_TIMEOUT = "hibernate.memcached.operationTimeout";
    public static final String PROP_HASH_ALGORITHM = "hibernate.memcached.hashAlgorithm";
    public static final String PROP_COMMAND_FACTORY = "hibernate.memcached.commandFactory";
    public static final String PROP_SESSION_LOCATOR = "hibernate.memcached.sessionLocator";
    private final PropertiesHelper properties;

    public XmemcachedClientFactory(PropertiesHelper properties) {
        this.properties = properties;
    }

    public Memcache createMemcacheClient() throws Exception {
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses(this.getServerList()));
        builder.setCommandFactory(this.getCommandFactory());
        builder.setSessionLocator(this.getSessionLocator());
        builder.getConfiguration().setSessionReadBufferSize(this.getReadBufferSize());
        MemcachedClient client = builder.build();
        client.setOpTimeout(this.getOperationTimeoutMillis());
        return new Xmemcache(client);
    }

    protected MemcachedSessionLocator getSessionLocator() {
        if (this.sessionLocatorNameEquals(ArrayMemcachedSessionLocator.class)) {
            return new ArrayMemcachedSessionLocator(this.getHashAlgorithm());
        }
        if (this.sessionLocatorNameEquals(KetamaMemcachedSessionLocator.class)) {
            return new KetamaMemcachedSessionLocator(this.getHashAlgorithm());
        }
        throw new IllegalArgumentException("Unsupported hibernate.memcached.sessionLocator value: " + this.getCommandFactoryName());
    }

    protected CommandFactory getCommandFactory() {
        if (this.commandFactoryNameEquals(TextCommandFactory.class)) {
            return new TextCommandFactory();
        }
        if (this.commandFactoryNameEquals(BinaryCommandFactory.class)) {
            return new BinaryCommandFactory();
        }
        throw new IllegalArgumentException("Unsupported hibernate.memcached.commandFactory value: " + this.getCommandFactoryName());
    }

    private boolean commandFactoryNameEquals(Class<?> cls) {
        return cls.getSimpleName().equals(this.getCommandFactoryName());
    }

    private boolean sessionLocatorNameEquals(Class<?> cls) {
        return cls.getSimpleName().equals(this.getSessionLocatorName());
    }

    public String getServerList() {
        return this.properties.get(PROP_SERVERS, "localhost:11211");
    }

    public int getReadBufferSize() {
        return this.properties.getInt(PROP_READ_BUFFER_SIZE, 131072);
    }

    public long getOperationTimeoutMillis() {
        return this.properties.getLong(PROP_OPERATION_TIMEOUT, 1000L);
    }

    public HashAlgorithm getHashAlgorithm() {
        return (HashAlgorithm)this.properties.getEnum(PROP_HASH_ALGORITHM, HashAlgorithm.class, (Enum)HashAlgorithm.NATIVE_HASH);
    }

    public String getCommandFactoryName() {
        return this.properties.get(PROP_COMMAND_FACTORY, TextCommandFactory.class.getSimpleName());
    }

    public String getSessionLocatorName() {
        return this.properties.get(PROP_SESSION_LOCATOR, ArrayMemcachedSessionLocator.class.getSimpleName());
    }

    protected PropertiesHelper getProperties() {
        return this.properties;
    }
}

