/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.core.impl;

import com.google.code.yanf4j.core.Dispatcher;
import com.google.code.yanf4j.util.WorkerThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PoolDispatcher
implements Dispatcher {
    public static int POOL_QUEUE_SIZE_FACTOR = 1000;
    public static float MAX_POOL_SIZE_FACTOR = 1.25f;
    private ThreadPoolExecutor threadPool;

    public PoolDispatcher(int poolSize) {
        this(poolSize, 60L, TimeUnit.SECONDS, new ThreadPoolExecutor.AbortPolicy(), "pool-dispatcher");
    }

    public PoolDispatcher(int poolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler rejectedExecutionHandler, String prefix) {
        this.threadPool = new ThreadPoolExecutor(poolSize, (int)(MAX_POOL_SIZE_FACTOR * (float)poolSize), keepAliveTime, unit, new ArrayBlockingQueue<Runnable>(poolSize * POOL_QUEUE_SIZE_FACTOR), new WorkerThreadFactory(prefix));
        this.threadPool.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public final void dispatch(Runnable r) {
        if (!this.threadPool.isShutdown()) {
            this.threadPool.execute(r);
        }
    }

    public void stop() {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

