/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.util.ByteBufferMatcher;
import com.google.code.yanf4j.util.ByteBufferUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftAndByteBufferMatcher
implements ByteBufferMatcher {
    private int[] b;
    private int mask;
    private int patternLimit;
    private int patternPos;
    private int patternLen;

    public ShiftAndByteBufferMatcher(IoBuffer pat) {
        if (pat == null || pat.remaining() == 0) {
            throw new IllegalArgumentException("blank buffer");
        }
        this.patternLimit = pat.limit();
        this.patternPos = pat.position();
        this.patternLen = pat.remaining();
        this.preprocess(pat);
        this.mask = 1 << this.patternLen - 1;
    }

    private void preprocess(IoBuffer pat) {
        this.b = new int[256];
        for (int i = this.patternPos; i < this.patternLimit; ++i) {
            int p = ByteBufferUtils.uByte(pat.get(i));
            this.b[p] = this.b[p] | 1 << i;
        }
    }

    @Override
    public final List<Integer> matchAll(IoBuffer buffer) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        int bufferLimit = buffer.limit();
        int d = 0;
        for (int pos = buffer.position(); pos < bufferLimit; ++pos) {
            d <<= 1;
            d |= 1;
            if (((d &= this.b[ByteBufferUtils.uByte(buffer.get(pos))]) & this.mask) == 0) continue;
            matches.add(pos - this.patternLen + 1);
        }
        return matches;
    }

    @Override
    public final int matchFirst(IoBuffer buffer) {
        if (buffer == null) {
            return -1;
        }
        int bufferLimit = buffer.limit();
        int d = 0;
        for (int pos = buffer.position(); pos < bufferLimit; ++pos) {
            d <<= 1;
            d |= 1;
            if (((d &= this.b[ByteBufferUtils.uByte(buffer.get(pos))]) & this.mask) == 0) continue;
            return pos - this.patternLen + 1;
        }
        return -1;
    }
}

