/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.auth;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTask
extends Thread {
    private final AuthInfo authInfo;
    private final CommandFactory commandFactory;
    private MemcachedTCPSession memcachedTCPSession;
    public static final byte[] EMPTY_BYTES = new byte[0];
    static final Logger log = LoggerFactory.getLogger(AuthTask.class);

    public AuthTask(AuthInfo authInfo, CommandFactory commandFactory, MemcachedTCPSession memcachedTCPSession) {
        this.authInfo = authInfo;
        this.commandFactory = commandFactory;
        this.memcachedTCPSession = memcachedTCPSession;
    }

    public void run() {
        if (this.authInfo.isValid()) {
            this.doAuth();
            this.authInfo.increaseAttempts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuth() {
        SaslClient saslClient = null;
        try {
            saslClient = Sasl.createSaslClient(this.authInfo.getMechanisms(), null, "memcached", this.memcachedTCPSession.getRemoteSocketAddress().toString(), null, this.authInfo.getCallbackHandler());
            AtomicBoolean done = new AtomicBoolean(false);
            byte[] response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(EMPTY_BYTES) : EMPTY_BYTES;
            CountDownLatch latch = new CountDownLatch(1);
            Command command = this.commandFactory.createAuthStartCommand(saslClient.getMechanismName(), latch, response);
            if (!this.memcachedTCPSession.isClosed()) {
                this.memcachedTCPSession.write(command);
            } else {
                log.error("Authentication fail,because the connection has been closed");
                throw new RuntimeException("Authentication fai,connection has been close");
            }
            block18: while (!done.get()) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    done.set(true);
                }
                ResponseStatus responseStatus = ((BaseBinaryCommand)command).getResponseStatus();
                switch (responseStatus) {
                    case NO_ERROR: {
                        done.set(true);
                        log.info("Authentication to " + this.memcachedTCPSession.getRemoteSocketAddress() + " successfully");
                        continue block18;
                    }
                    case AUTH_REQUIRED: {
                        log.error("Authentication failed to " + this.memcachedTCPSession.getRemoteSocketAddress());
                        log.warn("Reopen connection to " + this.memcachedTCPSession.getRemoteSocketAddress() + ",beacause auth fail");
                        this.memcachedTCPSession.setAuthFailed(true);
                        if (!this.authInfo.isFirstTime()) {
                            Thread.sleep(1000L);
                        }
                        this.memcachedTCPSession.close();
                        done.set(true);
                        continue block18;
                    }
                    case FUTHER_AUTH_REQUIRED: {
                        String result = (String)command.getResult();
                        response = saslClient.evaluateChallenge(ByteUtils.getBytes(result));
                        latch = new CountDownLatch(1);
                        command = this.commandFactory.createAuthStepCommand(saslClient.getMechanismName(), latch, response);
                        if (!this.memcachedTCPSession.isClosed()) {
                            this.memcachedTCPSession.write(command);
                            continue block18;
                        }
                        log.error("Authentication fail,because the connection has been closed");
                        throw new RuntimeException("Authentication fai,connection has been close");
                    }
                }
                done.set(true);
                log.error("Authentication failed to " + this.memcachedTCPSession.getRemoteSocketAddress() + ",response status=" + (Object)((Object)responseStatus));
            }
        }
        catch (Exception e) {
            log.error("Create saslClient error", (Throwable)e);
        }
        finally {
            if (saslClient != null) {
                try {
                    saslClient.dispose();
                }
                catch (SaslException e) {
                    log.error("Dispose saslClient error", (Throwable)e);
                }
            }
        }
    }
}

