/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.transcoders.CachedData;

public class BinaryAuthStartCommand
extends BaseBinaryCommand {
    public BinaryAuthStartCommand(String mechanism, byte[] keyBytes, CountDownLatch latch, byte[] authData) {
        super(mechanism, keyBytes, CommandType.AUTH_START, latch, 0, 0L, authData, false, null);
        this.opCode = OpCode.AUTH_START;
    }

    protected void fillExtras(CachedData data) {
    }

    protected void fillValue(CachedData data) {
        if (this.value != null) {
            this.ioBuffer.put((byte[])this.value);
        }
    }

    protected int getValueLength(CachedData data) {
        if (this.value == null) {
            return 0;
        }
        return ((byte[])this.value).length;
    }

    protected byte getExtrasLength() {
        return 0;
    }

    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        int valueLength = bodyLength - keyLength - extrasLength;
        if (buffer.remaining() < valueLength) {
            return false;
        }
        byte[] bytes = new byte[valueLength];
        buffer.get(bytes);
        this.setResult(new String(bytes));
        this.countDownLatch();
        return true;
    }
}

