/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.EmptyStackException;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorFactory {
    public static final int DEFAULT_MAX_SELECTORS = 20;
    private static final Logger logger = LoggerFactory.getLogger(SelectorFactory.class);
    public static final long timeout = 5000L;
    private static int maxSelectors;
    private static final Stack<Selector> selectors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setMaxSelectors(int size) throws IOException {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            if (size < maxSelectors) {
                SelectorFactory.reduce(size);
            } else if (size > maxSelectors) {
                SelectorFactory.grow(size);
            }
            maxSelectors = size;
        }
    }

    public static final int getMaxSelectors() {
        return maxSelectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector getSelector() {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            Selector s = null;
            try {
                if (selectors.size() != 0) {
                    s = selectors.pop();
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            try {
                for (int attempts = 0; s == null && attempts < 2; ++attempts) {
                    selectors.wait(5000L);
                    try {
                        if (selectors.size() == 0) continue;
                        s = selectors.pop();
                        continue;
                    }
                    catch (EmptyStackException ex) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void returnSelector(Selector s) {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            selectors.push(s);
            if (selectors.size() == 1) {
                selectors.notify();
            }
        }
    }

    private static void grow(int size) throws IOException {
        for (int i = 0; i < size - maxSelectors; ++i) {
            selectors.add(Selector.open());
        }
    }

    private static void reduce(int size) {
        for (int i = 0; i < maxSelectors - size; ++i) {
            try {
                Selector selector = selectors.pop();
                selector.close();
                continue;
            }
            catch (IOException e) {
                logger.error("SelectorFactory.reduce", (Throwable)e);
            }
        }
    }

    static {
        selectors = new Stack();
        try {
            SelectorFactory.setMaxSelectors(20);
        }
        catch (IOException ex) {
            logger.warn("SelectorFactory initializing Selector pool", (Throwable)ex);
        }
    }
}

