/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public WorkerThreadFactory(ThreadGroup group, String prefix) {
        SecurityManager s;
        this.group = group == null ? ((s = System.getSecurityManager()) != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup()) : group;
        this.namePrefix = prefix == null ? "pool-" + poolNumber.getAndIncrement() + "-thread-" : prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
    }

    public WorkerThreadFactory(String prefix) {
        this(null, prefix);
    }

    public WorkerThreadFactory() {
        this(null, null);
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(true);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

