/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.nio.impl;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.EventType;
import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.core.impl.FutureImpl;
import com.google.code.yanf4j.core.impl.WriteMessageImpl;
import com.google.code.yanf4j.nio.NioSessionConfig;
import com.google.code.yanf4j.nio.impl.AbstractNioSession;
import com.google.code.yanf4j.util.ByteBufferUtils;
import com.google.code.yanf4j.util.SelectorFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioTCPSession
extends AbstractNioSession {
    private InetSocketAddress remoteAddress;

    @Override
    public final boolean isExpired() {
        if (log.isDebugEnabled()) {
            log.debug("sessionTimeout=" + this.sessionTimeout + ",this.timestamp=" + this.lastOperationTimeStamp.get() + ",current=" + System.currentTimeMillis());
        }
        return this.sessionTimeout <= 0L ? false : System.currentTimeMillis() - this.lastOperationTimeStamp.get() >= this.sessionTimeout;
    }

    public NioTCPSession(NioSessionConfig sessionConfig, int readRecvBufferSize) {
        super(sessionConfig);
        if (this.selectableChannel != null && this.getRemoteSocketAddress() != null) {
            this.loopback = this.getRemoteSocketAddress().getAddress().isLoopbackAddress();
        }
        this.setReadBuffer(IoBuffer.allocate(readRecvBufferSize));
        this.onCreated();
    }

    @Override
    protected Object writeToChannel(WriteMessage message) throws IOException {
        long n;
        if (message.getWriteFuture() != null && !message.isWriting() && message.getWriteFuture().isCancelled()) {
            return message.getMessage();
        }
        if (message.getWriteBuffer() == null) {
            if (message.getWriteFuture() != null) {
                message.getWriteFuture().setResult(Boolean.TRUE);
            }
            return message.getMessage();
        }
        IoBuffer writeBuffer = message.getWriteBuffer();
        message.writing();
        if (this.useBlockingWrite) {
            return this.blockingWrite(this.selectableChannel, message, writeBuffer);
        }
        do {
            if ((n = this.doRealWrite(this.selectableChannel, writeBuffer)) > 0L) {
                this.statistics.statisticsWrite(n);
                this.scheduleWritenBytes.addAndGet(0L - n);
            }
            if (writeBuffer != null && writeBuffer.hasRemaining()) continue;
            if (message.getWriteFuture() != null) {
                message.getWriteFuture().setResult(Boolean.TRUE);
            }
            return message.getMessage();
        } while (n != 0L);
        return null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = (InetSocketAddress)((SocketChannel)this.selectableChannel).socket().getRemoteSocketAddress();
        }
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object blockingWrite(SelectableChannel channel, WriteMessage message, IoBuffer writeBuffer) throws IOException, ClosedChannelException {
        SelectionKey tmpKey = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesProduced = 0;
        try {
            while (writeBuffer.hasRemaining()) {
                long len = this.doRealWrite(channel, writeBuffer);
                if (len > 0L) {
                    attempts = 0;
                    bytesProduced = (int)((long)bytesProduced + len);
                    this.statistics.statisticsWrite(len);
                    continue;
                }
                ++attempts;
                if (writeSelector == null) {
                    writeSelector = SelectorFactory.getSelector();
                    if (writeSelector == null) continue;
                    tmpKey = channel.register(writeSelector, 4);
                }
                if (writeSelector.select(1000L) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
            if (!writeBuffer.hasRemaining() && message.getWriteFuture() != null) {
                message.getWriteFuture().setResult(Boolean.TRUE);
            }
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
                tmpKey = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
        this.scheduleWritenBytes.addAndGet(0 - bytesProduced);
        return message.getMessage();
    }

    @Override
    protected WriteMessage wrapMessage(Object msg, Future<Boolean> writeFuture) {
        WriteMessageImpl message = new WriteMessageImpl(msg, (FutureImpl)writeFuture);
        if (message.getWriteBuffer() == null) {
            message.setWriteBuffer(this.encoder.encode(message.getMessage(), this));
        }
        return message;
    }

    @Override
    protected void readFromBuffer() {
        if (!this.readBuffer.hasRemaining()) {
            if (this.readBuffer.capacity() < 131072) {
                this.readBuffer = IoBuffer.wrap(ByteBufferUtils.increaseBufferCapatity(this.readBuffer.buf()));
            } else {
                return;
            }
        }
        if (this.closed) {
            return;
        }
        int n = -1;
        int readCount = 0;
        try {
            while ((n = ((ReadableByteChannel)((Object)this.selectableChannel)).read(this.readBuffer.buf())) > 0) {
                readCount += n;
            }
            if (readCount > 0) {
                this.decodeAndDispatch();
            } else if (readCount == 0 && !((SocketChannel)this.selectableChannel).socket().isInputShutdown() && this.useBlockingRead && (n = this.blockingRead()) > 0) {
                readCount += n;
            }
            if (n < 0) {
                this.close();
            } else {
                this.selectorManager.registerSession(this, EventType.ENABLE_READ);
            }
            if (log.isDebugEnabled()) {
                log.debug("read " + readCount + " bytes from channel");
            }
        }
        catch (ClosedChannelException e) {
            this.close();
        }
        catch (Throwable e) {
            this.onException(e);
            this.close();
        }
    }

    private void decodeAndDispatch() {
        this.updateTimeStamp();
        this.readBuffer.flip();
        this.decode();
        this.readBuffer.compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int blockingRead() throws ClosedChannelException, IOException {
        int n = 0;
        int readCount = 0;
        Selector readSelector = SelectorFactory.getSelector();
        SelectionKey tmpKey = null;
        try {
            if (this.selectableChannel.isOpen()) {
                tmpKey = this.selectableChannel.register(readSelector, 0);
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                int code = readSelector.select(500L);
                tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
                if (code > 0) {
                    do {
                        n = ((ReadableByteChannel)((Object)this.selectableChannel)).read(this.readBuffer.buf());
                        readCount += n;
                        if (!log.isDebugEnabled()) continue;
                        log.debug("use temp selector read " + n + " bytes");
                    } while (n > 0 && this.readBuffer.hasRemaining());
                    if (readCount > 0) {
                        this.decodeAndDispatch();
                    }
                }
            }
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
                tmpKey = null;
            }
            if (readSelector != null) {
                readSelector.selectNow();
                SelectorFactory.returnSelector(readSelector);
            }
        }
        return readCount;
    }

    @Override
    public void decode() {
        int size = this.readBuffer.remaining();
        while (this.readBuffer.hasRemaining()) {
            try {
                Object message = this.decoder.decode(this.readBuffer, this);
                if (message == null) break;
                if (this.statistics.isStatistics()) {
                    this.statistics.statisticsRead(size - this.readBuffer.remaining());
                    size = this.readBuffer.remaining();
                }
                this.dispatchReceivedMessage(message);
            }
            catch (Exception e) {
                this.onException(e);
                log.error("Decode error", (Throwable)e);
                super.close();
                break;
            }
        }
    }

    public Socket socket() {
        return ((SocketChannel)this.selectableChannel).socket();
    }

    @Override
    protected final void closeChannel() throws IOException {
        this.flush0();
        Socket socket = ((SocketChannel)this.selectableChannel).socket();
        try {
            if (!socket.isClosed() && !socket.isOutputShutdown()) {
                socket.shutdownOutput();
            }
            if (!socket.isClosed() && !socket.isInputShutdown()) {
                socket.shutdownInput();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unregisterSession();
        this.unregisterChannel();
    }
}

