/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.impl.AbstractMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KetamaMemcachedSessionLocator
extends AbstractMemcachedSessionLocator {
    static final int NUM_REPS = 160;
    private volatile transient TreeMap<Long, List<Session>> ketamaSessions = new TreeMap();
    private final HashAlgorithm hashAlg;
    private int maxTries;
    private final Random random = new Random();
    static final int DEFAULT_PORT = 11211;
    private final boolean cwNginxUpstreamConsistent;

    public KetamaMemcachedSessionLocator() {
        this.hashAlg = HashAlgorithm.KETAMA_HASH;
        this.cwNginxUpstreamConsistent = false;
    }

    public KetamaMemcachedSessionLocator(boolean cwNginxUpstreamConsistent) {
        this.hashAlg = HashAlgorithm.KETAMA_HASH;
        this.cwNginxUpstreamConsistent = cwNginxUpstreamConsistent;
    }

    public KetamaMemcachedSessionLocator(HashAlgorithm alg) {
        this.hashAlg = alg;
        this.cwNginxUpstreamConsistent = false;
    }

    public KetamaMemcachedSessionLocator(HashAlgorithm alg, boolean cwNginxUpstreamConsistent) {
        this.hashAlg = alg;
        this.cwNginxUpstreamConsistent = cwNginxUpstreamConsistent;
    }

    public KetamaMemcachedSessionLocator(List<Session> list, HashAlgorithm alg) {
        this.hashAlg = alg;
        this.cwNginxUpstreamConsistent = false;
        this.buildMap(list, alg);
    }

    private final void buildMap(Collection<Session> list, HashAlgorithm alg) {
        TreeMap<Long, List<Session>> sessionMap = new TreeMap<Long, List<Session>>();
        for (Session session : list) {
            int i;
            String sockStr = null;
            if (this.cwNginxUpstreamConsistent) {
                InetSocketAddress serverAddress = session.getRemoteSocketAddress();
                sockStr = serverAddress.getAddress().getHostAddress();
                if (serverAddress.getPort() != 11211) {
                    sockStr = sockStr + ":" + serverAddress.getPort();
                }
            } else {
                if (session instanceof MemcachedTCPSession) {
                    sockStr = ((MemcachedTCPSession)session).getInetSocketAddressWrapper().getRemoteAddressStr();
                }
                if (sockStr == null) {
                    sockStr = String.valueOf(session.getRemoteSocketAddress());
                }
            }
            int numReps = 160;
            if (session instanceof MemcachedTCPSession) {
                numReps *= ((MemcachedSession)session).getWeight();
            }
            if (alg == HashAlgorithm.KETAMA_HASH) {
                for (i = 0; i < numReps / 4; ++i) {
                    byte[] digest = HashAlgorithm.computeMd5(sockStr + "-" + i);
                    for (int h = 0; h < 4; ++h) {
                        long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                        this.getSessionList(sessionMap, k).add(session);
                    }
                }
                continue;
            }
            for (i = 0; i < numReps; ++i) {
                long key = alg.hash(sockStr + "-" + i);
                this.getSessionList(sessionMap, key).add(session);
            }
        }
        this.ketamaSessions = sessionMap;
        this.maxTries = list.size();
    }

    private List<Session> getSessionList(TreeMap<Long, List<Session>> sessionMap, long k) {
        List<Session> sessionList = sessionMap.get(k);
        if (sessionList == null) {
            sessionList = new ArrayList<Session>();
            sessionMap.put(k, sessionList);
        }
        return sessionList;
    }

    @Override
    public final Session getSessionByKey(String key) {
        if (this.ketamaSessions == null || this.ketamaSessions.size() == 0) {
            return null;
        }
        long hash = this.hashAlg.hash(key);
        Session rv = this.getSessionByHash(hash);
        int tries = 0;
        while (!this.failureMode && (rv == null || rv.isClosed()) && tries++ < this.maxTries) {
            hash = this.nextHash(hash, key, tries);
            rv = this.getSessionByHash(hash);
        }
        return rv;
    }

    public final Session getSessionByHash(long hash) {
        List<Session> sessionList;
        TreeMap<Long, List<Session>> sessionMap = this.ketamaSessions;
        if (sessionMap.size() == 0) {
            return null;
        }
        Long resultHash = hash;
        if (!sessionMap.containsKey(hash)) {
            SortedMap<Long, List<Session>> tailMap = sessionMap.tailMap(hash);
            resultHash = tailMap.isEmpty() ? sessionMap.firstKey() : tailMap.firstKey();
        }
        if ((sessionList = sessionMap.get(resultHash)) == null || sessionList.size() == 0) {
            return null;
        }
        int size = sessionList.size();
        return sessionList.get(this.random.nextInt(size));
    }

    public final long nextHash(long hashVal, String key, int tries) {
        long tmpKey = this.hashAlg.hash(tries + key);
        hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
        return hashVal &= 0xFFFFFFFFL;
    }

    @Override
    public final void updateSessions(Collection<Session> list) {
        this.buildMap(list, this.hashAlg);
    }
}

