/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import java.net.InetSocketAddress;

public class InetSocketAddressWrapper {
    private InetSocketAddress inetSocketAddress;
    private int order;
    private int weight;
    private volatile String remoteAddressStr;
    private volatile String hostName;
    private volatile String mainNodeHostName;
    private InetSocketAddress mainNodeAddress;

    public InetSocketAddressWrapper(InetSocketAddress inetSocketAddress, int order, int weight, InetSocketAddress mainNodeAddress) {
        this.setInetSocketAddress(inetSocketAddress);
        this.setMainNodeAddress(mainNodeAddress);
        this.order = order;
        this.weight = weight;
    }

    public String getRemoteAddressStr() {
        return this.remoteAddressStr;
    }

    public void setRemoteAddressStr(String remoteAddressStr) {
        this.remoteAddressStr = remoteAddressStr;
    }

    public final InetSocketAddress getInetSocketAddress() {
        if (this.isValidHostName(this.hostName)) {
            return new InetSocketAddress(this.hostName, this.inetSocketAddress.getPort());
        }
        return this.inetSocketAddress;
    }

    private boolean isValidHostName(String h) {
        return h != null && h.trim().length() > 0;
    }

    public final void setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
        if (inetSocketAddress != null) {
            this.hostName = inetSocketAddress.getHostName();
        }
    }

    public final int getOrder() {
        return this.order;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public InetSocketAddress getMainNodeAddress() {
        if (this.isValidHostName(this.mainNodeHostName)) {
            return new InetSocketAddress(this.mainNodeHostName, this.mainNodeAddress.getPort());
        }
        return this.mainNodeAddress;
    }

    public void setMainNodeAddress(InetSocketAddress mainNodeAddress) {
        this.mainNodeAddress = mainNodeAddress;
        if (mainNodeAddress != null) {
            this.mainNodeHostName = mainNodeAddress.getHostName();
        }
    }

    public final void setOrder(int order) {
        this.order = order;
    }
}

