/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.core.impl;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.Session;

public class ByteBufferCodecFactory
implements CodecFactory {
    static final IoBuffer EMPTY_BUFFER = IoBuffer.allocate(0);
    private boolean direct;
    private CodecFactory.Decoder decoder;
    private CodecFactory.Encoder encoder;

    public ByteBufferCodecFactory() {
        this(false);
    }

    public ByteBufferCodecFactory(boolean direct) {
        this.direct = direct;
        this.encoder = new ByteBufferEncoder();
        this.decoder = new ByteBufferDecoder();
    }

    public CodecFactory.Decoder getDecoder() {
        return this.decoder;
    }

    public CodecFactory.Encoder getEncoder() {
        return this.encoder;
    }

    public class ByteBufferEncoder
    implements CodecFactory.Encoder {
        public IoBuffer encode(Object message, Session session) {
            IoBuffer msgBuffer = (IoBuffer)message;
            if (msgBuffer == null) {
                return null;
            }
            if (msgBuffer.remaining() == 0) {
                return EMPTY_BUFFER;
            }
            byte[] bytes = new byte[msgBuffer.remaining()];
            msgBuffer.get(bytes);
            IoBuffer result = IoBuffer.allocate(bytes.length, ByteBufferCodecFactory.this.direct);
            result.put(bytes);
            result.flip();
            return result;
        }
    }

    public class ByteBufferDecoder
    implements CodecFactory.Decoder {
        public Object decode(IoBuffer buff, Session session) {
            if (buff == null) {
                return null;
            }
            if (buff.remaining() == 0) {
                return EMPTY_BUFFER;
            }
            byte[] bytes = new byte[buff.remaining()];
            buff.get(bytes);
            IoBuffer result = IoBuffer.allocate(bytes.length, ByteBufferCodecFactory.this.direct);
            result.put(bytes);
            result.flip();
            return result;
        }
    }
}

