/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.nio.impl;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.EventType;
import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.core.impl.AbstractSession;
import com.google.code.yanf4j.nio.NioSession;
import com.google.code.yanf4j.nio.NioSessionConfig;
import com.google.code.yanf4j.nio.impl.Reactor;
import com.google.code.yanf4j.nio.impl.SelectorManager;
import com.google.code.yanf4j.util.SelectorFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public abstract class AbstractNioSession
extends AbstractSession
implements NioSession {
    protected SelectorManager selectorManager;
    protected SelectableChannel selectableChannel;

    public SelectableChannel channel() {
        return this.selectableChannel;
    }

    public AbstractNioSession(NioSessionConfig sessionConfig) {
        super(sessionConfig);
        this.selectorManager = sessionConfig.selectorManager;
        this.selectableChannel = sessionConfig.selectableChannel;
    }

    public final void enableRead(Selector selector) {
        SelectionKey key = this.selectableChannel.keyFor(selector);
        if (key != null && key.isValid()) {
            this.interestRead(key);
        } else {
            try {
                this.selectableChannel.register(selector, 1, this);
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    private void interestRead(SelectionKey key) {
        if (key.attachment() == null) {
            key.attach(this);
        }
        key.interestOps(key.interestOps() | 1);
    }

    protected void start0() {
        this.registerSession();
    }

    public InetAddress getLocalAddress() {
        return ((SocketChannel)this.selectableChannel).socket().getLocalAddress();
    }

    protected abstract Object writeToChannel(WriteMessage var1) throws ClosedChannelException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onWrite(SelectionKey key) {
        boolean isLockedByMe = false;
        if (this.currentMessage.get() == null) {
            WriteMessage nextMessage = (WriteMessage)this.writeQueue.peek();
            if (nextMessage == null || !this.writeLock.tryLock()) return;
            if (!this.writeQueue.isEmpty() && this.currentMessage.compareAndSet(null, nextMessage)) {
                this.writeQueue.remove();
            }
        } else if (!this.writeLock.tryLock()) {
            return;
        }
        isLockedByMe = true;
        WriteMessage currentMessage = null;
        long maxWritten = this.readBuffer.capacity() + this.readBuffer.capacity() >>> 1;
        try {
            long written = 0L;
            while (this.currentMessage.get() != null) {
                currentMessage = (WriteMessage)this.currentMessage.get();
                currentMessage = this.preprocessWriteMessage(currentMessage);
                this.currentMessage.set(currentMessage);
                long before = ((WriteMessage)this.currentMessage.get()).getWriteBuffer().remaining();
                Object writeResult = null;
                if (written < maxWritten) {
                    writeResult = this.writeToChannel(currentMessage);
                    written += (long)((WriteMessage)this.currentMessage.get()).getWriteBuffer().remaining() - before;
                }
                if (writeResult != null) {
                    WriteMessage nextMessage;
                    this.currentMessage.set(this.writeQueue.poll());
                    this.handler.onMessageSent(this, currentMessage.getMessage());
                    if (this.currentMessage.get() != null) continue;
                    if (isLockedByMe) {
                        isLockedByMe = false;
                        this.writeLock.unlock();
                    }
                    if ((nextMessage = (WriteMessage)this.writeQueue.peek()) == null || !this.writeLock.tryLock()) return;
                    isLockedByMe = true;
                    if (this.writeQueue.isEmpty() || !this.currentMessage.compareAndSet(null, nextMessage)) continue;
                    this.writeQueue.remove();
                    continue;
                }
                if (isLockedByMe) {
                    isLockedByMe = false;
                    this.writeLock.unlock();
                }
                this.selectorManager.registerSession(this, EventType.ENABLE_WRITE);
                return;
            }
            return;
        }
        catch (IOException e) {
            this.handler.onExceptionCaught(this, e);
            if (currentMessage != null && currentMessage.getWriteFuture() != null) {
                currentMessage.getWriteFuture().failure(e);
            }
            if (isLockedByMe) {
                isLockedByMe = false;
                this.writeLock.unlock();
            }
            this.close();
            return;
        }
        finally {
            if (isLockedByMe) {
                this.writeLock.unlock();
            }
        }
    }

    public final void enableWrite(Selector selector) {
        SelectionKey key = this.selectableChannel.keyFor(selector);
        if (key != null && key.isValid()) {
            this.interestWrite(key);
        } else {
            try {
                this.selectableChannel.register(selector, 4, this);
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    private void interestWrite(SelectionKey key) {
        if (key.attachment() == null) {
            key.attach(this);
        }
        key.interestOps(key.interestOps() | 4);
    }

    protected void onRead(SelectionKey key) {
        this.readFromBuffer();
    }

    protected abstract void readFromBuffer();

    protected void closeChannel() throws IOException {
        this.flush0();
        this.unregisterSession();
        this.unregisterChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unregisterChannel() throws IOException {
        this.writeLock.lock();
        try {
            if (this.getAttribute(SelectorManager.REACTOR_ATTRIBUTE) != null) {
                ((Reactor)this.getAttribute(SelectorManager.REACTOR_ATTRIBUTE)).unregisterChannel(this.selectableChannel);
            }
            if (this.selectableChannel.isOpen()) {
                this.selectableChannel.close();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected final void registerSession() {
        this.selectorManager.registerSession(this, EventType.REGISTER);
    }

    protected void unregisterSession() {
        this.selectorManager.registerSession(this, EventType.UNREGISTER);
    }

    public void writeFromUserCode(WriteMessage message) {
        if (this.schduleWriteMessage(message)) {
            return;
        }
        this.onWrite(null);
    }

    protected boolean schduleWriteMessage(WriteMessage writeMessage) {
        boolean offered = this.writeQueue.offer(writeMessage);
        assert (offered);
        Reactor reactor = this.selectorManager.getReactorFromSession(this);
        if (Thread.currentThread() != reactor) {
            this.selectorManager.registerSession(this, EventType.ENABLE_WRITE);
            return true;
        }
        return false;
    }

    public void flush() {
        if (this.isClosed()) {
            return;
        }
        this.flush0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flush0() {
        SelectionKey tmpKey = null;
        Selector writeSelector = null;
        int attempts = 0;
        try {
            block26: {
                do {
                    if (writeSelector == null) {
                        writeSelector = SelectorFactory.getSelector();
                        if (writeSelector == null) {
                            return;
                        }
                        tmpKey = this.selectableChannel.register(writeSelector, 4);
                    }
                    if (writeSelector.select(1000L) != 0) break block26;
                } while (++attempts <= 2);
                return;
            }
            this.onWrite(this.selectableChannel.keyFor(writeSelector));
        }
        catch (ClosedChannelException cce) {
            this.onException(cce);
            log.error("Flush error", (Throwable)cce);
            this.close();
        }
        catch (IOException ioe) {
            this.onException(ioe);
            log.error("Flush error", (Throwable)ioe);
            this.close();
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
                tmpKey = null;
            }
            if (writeSelector != null) {
                try {
                    writeSelector.selectNow();
                }
                catch (IOException e) {
                    log.error("Temp selector selectNow error", (Throwable)e);
                }
                SelectorFactory.returnSelector(writeSelector);
            }
        }
    }

    protected final long doRealWrite(SelectableChannel channel, IoBuffer buffer) throws IOException {
        if (log.isDebugEnabled()) {
            StringBuffer bufMsg = new StringBuffer("send buffers:\n[\n");
            ByteBuffer buff = buffer.buf();
            bufMsg.append(" buffer:position=").append(buff.position()).append(",limit=").append(buff.limit()).append(",capacity=").append(buff.capacity()).append("\n");
            bufMsg.append("]");
            log.debug(bufMsg.toString());
        }
        return ((WritableByteChannel)((Object)channel)).write(buffer.buf());
    }

    public final void onEvent(EventType event, Selector selector) {
        if (this.isClosed()) {
            return;
        }
        SelectionKey key = this.selectableChannel.keyFor(selector);
        switch (event) {
            case EXPIRED: {
                this.onExpired();
                break;
            }
            case WRITEABLE: {
                this.onWrite(key);
                break;
            }
            case READABLE: {
                this.onRead(key);
                break;
            }
            case ENABLE_WRITE: {
                this.enableWrite(selector);
                break;
            }
            case ENABLE_READ: {
                this.enableRead(selector);
                break;
            }
            case IDLE: {
                this.onIdle();
                break;
            }
            case CONNECTED: {
                this.onConnected();
                break;
            }
            default: {
                log.error("Unknown event:" + event.name());
            }
        }
    }
}

