/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.Counter;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedClientCallable;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.impl.ReconnectRequest;
import net.rubyeye.xmemcached.networking.Connector;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MemcachedClient {
    public static final int DEFAULT_READ_THREAD_COUNT = 0;
    public static final boolean DEFAULT_TCP_KEEPLIVE = true;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_TCP_SEND_BUFF_SIZE = 32768;
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final int DEFAULT_SESSION_READ_BUFF_SIZE = 131072;
    public static final int DEFAULT_TCP_RECV_BUFF_SIZE = 65536;
    public static final long DEFAULT_OP_TIMEOUT = 5000L;
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 1;
    public static final int DEFAULT_SESSION_IDLE_TIMEOUT = 5000;
    public static final long DEFAULT_HEAL_SESSION_INTERVAL = 2000L;
    public static final int MAX_QUEUED_NOPS = 40000;
    public static final int DYNAMIC_MAX_QUEUED_NOPS = (int)(40000.0 * ((double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0 / 1024.0));
    public static final int DEFAULT_MAX_QUEUED_NOPS = DYNAMIC_MAX_QUEUED_NOPS > 40000 ? 40000 : DYNAMIC_MAX_QUEUED_NOPS;
    public static final int DEFAULT_MAX_TIMEOUTEXCEPTION_THRESHOLD = 1000;

    public void setMergeFactor(int var1);

    public long getConnectTimeout();

    public void setConnectTimeout(long var1);

    public Connector getConnector();

    public void setOptimizeGet(boolean var1);

    public void setOptimizeMergeBuffer(boolean var1);

    public boolean isShutdown();

    public void addServer(String var1, int var2) throws IOException;

    public void addServer(InetSocketAddress var1) throws IOException;

    public void addServer(String var1) throws IOException;

    public List<String> getServersDescription();

    public void removeServer(String var1);

    @Deprecated
    public void setBufferAllocator(BufferAllocator var1);

    public <T> T get(String var1, long var2, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> T get(String var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> T get(String var1, Transcoder<T> var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> T get(String var1) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> GetsResponse<T> gets(String var1, long var2, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> GetsResponse<T> gets(String var1) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> GetsResponse<T> gets(String var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> GetsResponse<T> gets(String var1, Transcoder var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, T> get(Collection<String> var1, long var2, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, T> get(Collection<String> var1, Transcoder<T> var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, T> get(Collection<String> var1) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, T> get(Collection<String> var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, GetsResponse<T>> gets(Collection<String> var1, long var2, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, GetsResponse<T>> gets(Collection<String> var1) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, GetsResponse<T>> gets(Collection<String> var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> Map<String, GetsResponse<T>> gets(Collection<String> var1, Transcoder<T> var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean set(String var1, int var2, T var3, Transcoder<T> var4, long var5) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean set(String var1, int var2, Object var3) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean set(String var1, int var2, Object var3, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean set(String var1, int var2, T var3, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public void setWithNoReply(String var1, int var2, Object var3) throws InterruptedException, MemcachedException;

    public <T> void setWithNoReply(String var1, int var2, T var3, Transcoder<T> var4) throws InterruptedException, MemcachedException;

    public <T> boolean add(String var1, int var2, T var3, Transcoder<T> var4, long var5) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean add(String var1, int var2, Object var3) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean add(String var1, int var2, Object var3, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean add(String var1, int var2, T var3, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public void addWithNoReply(String var1, int var2, Object var3) throws InterruptedException, MemcachedException;

    public <T> void addWithNoReply(String var1, int var2, T var3, Transcoder<T> var4) throws InterruptedException, MemcachedException;

    public <T> boolean replace(String var1, int var2, T var3, Transcoder<T> var4, long var5) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean replace(String var1, int var2, Object var3) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean replace(String var1, int var2, Object var3, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean replace(String var1, int var2, T var3, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public void replaceWithNoReply(String var1, int var2, Object var3) throws InterruptedException, MemcachedException;

    public <T> void replaceWithNoReply(String var1, int var2, T var3, Transcoder<T> var4) throws InterruptedException, MemcachedException;

    public boolean append(String var1, Object var2) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean append(String var1, Object var2, long var3) throws TimeoutException, InterruptedException, MemcachedException;

    public void appendWithNoReply(String var1, Object var2) throws InterruptedException, MemcachedException;

    public boolean prepend(String var1, Object var2) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean prepend(String var1, Object var2, long var3) throws TimeoutException, InterruptedException, MemcachedException;

    public void prependWithNoReply(String var1, Object var2) throws InterruptedException, MemcachedException;

    public boolean cas(String var1, int var2, Object var3, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, int var2, T var3, Transcoder<T> var4, long var5, long var7) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean cas(String var1, int var2, Object var3, long var4, long var6) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, int var2, T var3, Transcoder<T> var4, long var5) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, int var2, CASOperation<T> var3, Transcoder<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, int var2, GetsResponse<T> var3, CASOperation<T> var4, Transcoder<T> var5) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, int var2, GetsResponse<T> var3, CASOperation<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, GetsResponse<T> var2, CASOperation<T> var3) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, int var2, CASOperation<T> var3) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> boolean cas(String var1, CASOperation<T> var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> void casWithNoReply(String var1, GetsResponse<T> var2, CASOperation<T> var3) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> void casWithNoReply(String var1, int var2, GetsResponse<T> var3, CASOperation<T> var4) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> void casWithNoReply(String var1, int var2, CASOperation<T> var3) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> void casWithNoReply(String var1, CASOperation<T> var2) throws TimeoutException, InterruptedException, MemcachedException;

    @Deprecated
    public boolean delete(String var1, int var2) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean delete(String var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean delete(String var1, long var2, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean touch(String var1, int var2, long var3) throws TimeoutException, InterruptedException, MemcachedException;

    public boolean touch(String var1, int var2) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> T getAndTouch(String var1, int var2, long var3) throws TimeoutException, InterruptedException, MemcachedException;

    public <T> T getAndTouch(String var1, int var2) throws TimeoutException, InterruptedException, MemcachedException;

    public Map<InetSocketAddress, String> getVersions() throws TimeoutException, InterruptedException, MemcachedException;

    public long incr(String var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public long incr(String var1, long var2, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public long incr(String var1, long var2, long var4, long var6) throws TimeoutException, InterruptedException, MemcachedException;

    public long decr(String var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public long decr(String var1, long var2, long var4) throws TimeoutException, InterruptedException, MemcachedException;

    public long decr(String var1, long var2, long var4, long var6) throws TimeoutException, InterruptedException, MemcachedException;

    public void flushAll() throws TimeoutException, InterruptedException, MemcachedException;

    public void flushAllWithNoReply() throws InterruptedException, MemcachedException;

    public void flushAll(long var1) throws TimeoutException, InterruptedException, MemcachedException;

    public void flushAll(InetSocketAddress var1) throws MemcachedException, InterruptedException, TimeoutException;

    public void flushAllWithNoReply(InetSocketAddress var1) throws MemcachedException, InterruptedException;

    public void flushAll(InetSocketAddress var1, long var2) throws MemcachedException, InterruptedException, TimeoutException;

    @Deprecated
    public void flushAll(String var1) throws TimeoutException, InterruptedException, MemcachedException;

    public Map<String, String> stats(InetSocketAddress var1) throws MemcachedException, InterruptedException, TimeoutException;

    public Map<String, String> stats(InetSocketAddress var1, long var2) throws MemcachedException, InterruptedException, TimeoutException;

    public Map<InetSocketAddress, Map<String, String>> getStats(long var1) throws MemcachedException, InterruptedException, TimeoutException;

    public Map<InetSocketAddress, Map<String, String>> getStats() throws MemcachedException, InterruptedException, TimeoutException;

    public Map<InetSocketAddress, Map<String, String>> getStatsByItem(String var1) throws MemcachedException, InterruptedException, TimeoutException;

    public void shutdown() throws IOException;

    public boolean delete(String var1) throws TimeoutException, InterruptedException, MemcachedException;

    public Transcoder getTranscoder();

    public void setTranscoder(Transcoder var1);

    public Map<InetSocketAddress, Map<String, String>> getStatsByItem(String var1, long var2) throws MemcachedException, InterruptedException, TimeoutException;

    public long getOpTimeout();

    public void setOpTimeout(long var1);

    public Map<InetSocketAddress, String> getVersions(long var1) throws TimeoutException, InterruptedException, MemcachedException;

    @Deprecated
    public Collection<InetSocketAddress> getAvaliableServers();

    public Collection<InetSocketAddress> getAvailableServers();

    public void addServer(String var1, int var2, int var3) throws IOException;

    public void addServer(InetSocketAddress var1, int var2) throws IOException;

    @Deprecated
    public void deleteWithNoReply(String var1, int var2) throws InterruptedException, MemcachedException;

    public void deleteWithNoReply(String var1) throws InterruptedException, MemcachedException;

    public void incrWithNoReply(String var1, long var2) throws InterruptedException, MemcachedException;

    public void decrWithNoReply(String var1, long var2) throws InterruptedException, MemcachedException;

    public void setLoggingLevelVerbosity(InetSocketAddress var1, int var2) throws TimeoutException, InterruptedException, MemcachedException;

    public void setLoggingLevelVerbosityWithNoReply(InetSocketAddress var1, int var2) throws InterruptedException, MemcachedException;

    public void addStateListener(MemcachedClientStateListener var1);

    public void removeStateListener(MemcachedClientStateListener var1);

    public Collection<MemcachedClientStateListener> getStateListeners();

    public void flushAllWithNoReply(int var1) throws InterruptedException, MemcachedException;

    public void flushAll(int var1, long var2) throws TimeoutException, InterruptedException, MemcachedException;

    public void flushAllWithNoReply(InetSocketAddress var1, int var2) throws MemcachedException, InterruptedException;

    public void flushAll(InetSocketAddress var1, long var2, int var4) throws MemcachedException, InterruptedException, TimeoutException;

    public void setHealSessionInterval(long var1);

    public void setEnableHealSession(boolean var1);

    public long getHealSessionInterval();

    public Protocol getProtocol();

    public void setPrimitiveAsString(boolean var1);

    public void setConnectionPoolSize(int var1);

    public void setEnableHeartBeat(boolean var1);

    public void setSanitizeKeys(boolean var1);

    public boolean isSanitizeKeys();

    public Counter getCounter(String var1);

    public Counter getCounter(String var1, long var2);

    @Deprecated
    public KeyIterator getKeyIterator(InetSocketAddress var1) throws MemcachedException, InterruptedException, TimeoutException;

    public void setAuthInfoMap(Map<InetSocketAddress, AuthInfo> var1);

    public Map<InetSocketAddress, AuthInfo> getAuthInfoMap();

    public Map<String, AuthInfo> getAuthInfoStringMap();

    public long decr(String var1, long var2, long var4, long var6, int var8) throws TimeoutException, InterruptedException, MemcachedException;

    public long incr(String var1, long var2, long var4, long var6, int var8) throws TimeoutException, InterruptedException, MemcachedException;

    public String getName();

    public void setName(String var1);

    public Queue<ReconnectRequest> getReconnectRequestQueue();

    public void setFailureMode(boolean var1);

    public boolean isFailureMode();

    public void setKeyProvider(KeyProvider var1);

    public int getTimeoutExceptionThreshold();

    public void setTimeoutExceptionThreshold(int var1);

    public void invalidateNamespace(String var1) throws MemcachedException, InterruptedException, TimeoutException;

    public void invalidateNamespace(String var1, long var2) throws MemcachedException, InterruptedException, TimeoutException;

    public void endWithNamespace();

    public void beginWithNamespace(String var1);

    public <T> T withNamespace(String var1, MemcachedClientCallable<T> var2) throws MemcachedException, InterruptedException, TimeoutException;
}

