/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.core.SocketOption;
import com.google.code.yanf4j.util.SystemUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.Counter;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientCallable;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientMBean;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.buffer.SimpleBufferAllocator;
import net.rubyeye.xmemcached.codec.MemcachedCodecFactory;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.ServerAddressAware;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.exception.NoValueException;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.ClosedMemcachedTCPSession;
import net.rubyeye.xmemcached.impl.DefaultKeyProvider;
import net.rubyeye.xmemcached.impl.KeyIteratorImpl;
import net.rubyeye.xmemcached.impl.MemcachedClientStateListenerAdapter;
import net.rubyeye.xmemcached.impl.MemcachedConnector;
import net.rubyeye.xmemcached.impl.MemcachedHandler;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.impl.ReconnectRequest;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.monitor.MemcachedClientNameHolder;
import net.rubyeye.xmemcached.monitor.XMemcachedMbeanServer;
import net.rubyeye.xmemcached.networking.Connector;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import net.rubyeye.xmemcached.utils.ByteUtils;
import net.rubyeye.xmemcached.utils.InetSocketAddressWrapper;
import net.rubyeye.xmemcached.utils.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMemcachedClient
implements XMemcachedClientMBean,
MemcachedClient {
    private static final Logger log = LoggerFactory.getLogger(XMemcachedClient.class);
    protected MemcachedSessionLocator sessionLocator;
    private volatile boolean shutdown;
    protected MemcachedConnector connector;
    private Transcoder transcoder;
    private boolean sanitizeKeys;
    private MemcachedHandler memcachedHandler;
    protected CommandFactory commandFactory;
    protected long opTimeout = 5000L;
    private long connectTimeout = 60000L;
    protected int connectionPoolSize = 1;
    protected int maxQueuedNoReplyOperations = DEFAULT_MAX_QUEUED_NOPS;
    protected final AtomicInteger serverOrderCount = new AtomicInteger();
    private Map<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
    private Map<String, AuthInfo> authInfoStringMap = new HashMap<String, AuthInfo>();
    private String name;
    private boolean failureMode;
    private int timeoutExceptionThreshold = 1000;
    private final CopyOnWriteArrayList<MemcachedClientStateListenerAdapter> stateListenerAdapters = new CopyOnWriteArrayList();
    private Thread shutdownHookThread;
    private volatile boolean isHutdownHookCalled = false;
    private KeyProvider keyProvider = DefaultKeyProvider.INSTANCE;
    public static final ThreadLocal<String> NAMESPACE_LOCAL = new ThreadLocal();
    private static final String CONTINUOUS_TIMEOUT_COUNTER = "ContinuousTimeouts";

    @Override
    public final void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 0) {
            throw new IllegalArgumentException("mergeFactor<0");
        }
        this.connector.setMergeFactor(mergeFactor);
    }

    @Override
    public int getTimeoutExceptionThreshold() {
        return this.timeoutExceptionThreshold;
    }

    @Override
    public void setTimeoutExceptionThreshold(int timeoutExceptionThreshold) {
        if (timeoutExceptionThreshold <= 0) {
            throw new IllegalArgumentException("Illegal timeoutExceptionThreshold value " + timeoutExceptionThreshold);
        }
        if (timeoutExceptionThreshold < 100) {
            log.warn("Too small timeoutExceptionThreshold value may cause connections disconnect/reconnect frequently.");
        }
        this.timeoutExceptionThreshold = timeoutExceptionThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withNamespace(String ns, MemcachedClientCallable<T> callable) throws MemcachedException, InterruptedException, TimeoutException {
        this.beginWithNamespace(ns);
        try {
            T t = callable.call(this);
            return t;
        }
        finally {
            this.endWithNamespace();
        }
    }

    @Override
    public void endWithNamespace() {
        NAMESPACE_LOCAL.remove();
    }

    @Override
    public void beginWithNamespace(String ns) {
        if (ns == null || ns.trim().length() == 0) {
            throw new IllegalArgumentException("Blank namespace");
        }
        if (NAMESPACE_LOCAL.get() != null) {
            throw new IllegalStateException("Previous namespace wasn't ended.");
        }
        NAMESPACE_LOCAL.set(ns);
    }

    public KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public void setKeyProvider(KeyProvider keyProvider) {
        if (keyProvider == null) {
            throw new IllegalArgumentException("Null key provider");
        }
        this.keyProvider = keyProvider;
    }

    public final MemcachedSessionLocator getSessionLocator() {
        return this.sessionLocator;
    }

    public final CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long connectTimeout) {
        if (connectTimeout < 0L) {
            throw new IllegalArgumentException("connectTimeout<0");
        }
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setEnableHeartBeat(boolean enableHeartBeat) {
        this.memcachedHandler.setEnableHeartBeat(enableHeartBeat);
    }

    @Override
    public final long getOpTimeout() {
        return this.opTimeout;
    }

    @Override
    public final void setOpTimeout(long opTimeout) {
        if (opTimeout < 0L) {
            throw new IllegalArgumentException("opTimeout<0");
        }
        this.opTimeout = opTimeout;
    }

    @Override
    public void setHealSessionInterval(long healConnectionInterval) {
        if (healConnectionInterval <= 0L) {
            throw new IllegalArgumentException("Invalid heal session interval:" + healConnectionInterval);
        }
        if (null == this.connector) {
            throw new IllegalStateException("The client hasn't been started");
        }
        this.connector.setHealSessionInterval(healConnectionInterval);
    }

    @Override
    public long getHealSessionInterval() {
        if (null != this.connector) {
            return this.connector.getHealSessionInterval();
        }
        return -1L;
    }

    @Override
    public Map<InetSocketAddress, AuthInfo> getAuthInfoMap() {
        return this.authInfoMap;
    }

    @Override
    public void setAuthInfoMap(Map<InetSocketAddress, AuthInfo> map) {
        this.authInfoMap = map;
        this.authInfoStringMap = new HashMap<String, AuthInfo>();
        for (Map.Entry<InetSocketAddress, AuthInfo> entry : map.entrySet()) {
            String server = AddrUtil.getServerString(entry.getKey());
            this.authInfoStringMap.put(server, entry.getValue());
        }
    }

    @Override
    public Map<String, AuthInfo> getAuthInfoStringMap() {
        return this.authInfoStringMap;
    }

    @Override
    public final Connector getConnector() {
        return this.connector;
    }

    @Override
    public final void setOptimizeMergeBuffer(boolean optimizeMergeBuffer) {
        this.connector.setOptimizeMergeBuffer(optimizeMergeBuffer);
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown;
    }

    private final <T> GetsResponse<T> gets0(String key, byte[] keyBytes, Transcoder<T> transcoder) throws MemcachedException, TimeoutException, InterruptedException {
        GetsResponse result = (GetsResponse)this.fetch0(key, keyBytes, CommandType.GETS_ONE, this.opTimeout, transcoder);
        return result;
    }

    protected final Session sendCommand(Command cmd) throws MemcachedException {
        if (this.shutdown) {
            throw new MemcachedException("Xmemcached is stopped");
        }
        return this.connector.send(cmd);
    }

    public XMemcachedClient(String server, int port) throws IOException {
        this(server, port, 1);
    }

    public XMemcachedClient(String host, int port, int weight) throws IOException {
        if (weight <= 0) {
            throw new IllegalArgumentException("weight<=0");
        }
        this.checkServerPort(host, port);
        this.buildConnector(new ArrayMemcachedSessionLocator(), new SimpleBufferAllocator(), XMemcachedClientBuilder.getDefaultConfiguration(), XMemcachedClientBuilder.getDefaultSocketOptions(), new TextCommandFactory(), new SerializingTranscoder());
        this.start0();
        this.connect(new InetSocketAddressWrapper(this.newSocketAddress(host, port), this.serverOrderCount.incrementAndGet(), weight, null));
    }

    protected InetSocketAddress newSocketAddress(String server, int port) {
        return new InetSocketAddress(server, port);
    }

    private void checkServerPort(String server, int port) {
        if (server == null || server.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (port <= 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final void addServer(String server, int port) throws IOException {
        this.addServer(server, port, 1);
    }

    @Override
    public final void addServer(String server, int port, int weight) throws IOException {
        if (weight <= 0) {
            throw new IllegalArgumentException("weight<=0");
        }
        this.checkServerPort(server, port);
        this.connect(new InetSocketAddressWrapper(this.newSocketAddress(server, port), this.serverOrderCount.incrementAndGet(), weight, null));
    }

    @Override
    public final void addServer(InetSocketAddress inetSocketAddress) throws IOException {
        this.addServer(inetSocketAddress, 1);
    }

    @Override
    public final void addServer(InetSocketAddress inetSocketAddress, int weight) throws IOException {
        if (inetSocketAddress == null) {
            throw new IllegalArgumentException("Null InetSocketAddress");
        }
        if (weight <= 0) {
            throw new IllegalArgumentException("weight<=0");
        }
        this.connect(new InetSocketAddressWrapper(inetSocketAddress, this.serverOrderCount.incrementAndGet(), weight, null));
    }

    @Override
    public final void addServer(String hostList) throws IOException {
        Map<InetSocketAddress, InetSocketAddress> addresses = AddrUtil.getAddressMap(hostList);
        if (addresses != null && addresses.size() > 0) {
            for (Map.Entry<InetSocketAddress, InetSocketAddress> entry : addresses.entrySet()) {
                InetSocketAddress mainNodeAddr = entry.getKey();
                InetSocketAddress standbyNodeAddr = entry.getValue();
                this.connect(new InetSocketAddressWrapper(mainNodeAddr, this.serverOrderCount.incrementAndGet(), 1, null));
                if (standbyNodeAddr == null) continue;
                this.connect(new InetSocketAddressWrapper(standbyNodeAddr, this.serverOrderCount.incrementAndGet(), 1, mainNodeAddr));
            }
        }
    }

    @Override
    public void addOneServerWithWeight(String server, int weight) throws IOException {
        Map<InetSocketAddress, InetSocketAddress> addresses = AddrUtil.getAddressMap(server);
        if (addresses == null) {
            throw new IllegalArgumentException("Null Server");
        }
        if (addresses.size() != 1) {
            throw new IllegalArgumentException("Please add one server at one time");
        }
        if (weight <= 0) {
            throw new IllegalArgumentException("weight<=0");
        }
        if (addresses != null && addresses.size() > 0) {
            for (Map.Entry<InetSocketAddress, InetSocketAddress> entry : addresses.entrySet()) {
                InetSocketAddress mainNodeAddr = entry.getKey();
                InetSocketAddress standbyNodeAddr = entry.getValue();
                this.connect(new InetSocketAddressWrapper(mainNodeAddr, this.serverOrderCount.incrementAndGet(), 1, null));
                if (standbyNodeAddr == null) continue;
                this.connect(new InetSocketAddressWrapper(standbyNodeAddr, this.serverOrderCount.incrementAndGet(), 1, mainNodeAddr));
            }
        }
    }

    @Override
    public final List<String> getServersDescription() {
        ArrayList<String> result = new ArrayList<String>();
        for (Session session : this.connector.getSessionSet()) {
            InetSocketAddress socketAddress = session.getRemoteSocketAddress();
            int weight = ((MemcachedSession)session).getInetSocketAddressWrapper().getWeight();
            result.add(SystemUtils.getRawAddress(socketAddress) + ":" + socketAddress.getPort() + "(weight=" + weight + ")");
        }
        return result;
    }

    @Override
    public final void setServerWeight(String server, int weight) {
        InetSocketAddress socketAddress = AddrUtil.getOneAddress(server);
        Queue<Session> sessionQueue = this.connector.getSessionByAddress(socketAddress);
        if (sessionQueue == null) {
            throw new IllegalArgumentException("There is no server " + server);
        }
        for (Session session : sessionQueue) {
            if (session == null) continue;
            ((MemcachedTCPSession)session).getInetSocketAddressWrapper().setWeight(weight);
        }
        this.connector.updateSessions();
    }

    @Override
    public final void removeServer(String hostList) {
        List<InetSocketAddress> addresses = AddrUtil.getAddresses(hostList);
        if (addresses != null && addresses.size() > 0) {
            for (InetSocketAddress address : addresses) {
                this.removeAddr(address);
            }
        }
    }

    protected void removeAddr(InetSocketAddress address) {
        List<Session> standBySession;
        Queue<Session> sessionQueue = this.connector.getSessionByAddress(address);
        if (sessionQueue != null) {
            for (Session session : sessionQueue) {
                if (session == null) continue;
                ((MemcachedSession)session).setAllowReconnect(false);
                ((MemcachedSession)session).quit();
            }
        }
        if ((standBySession = this.connector.getStandbySessionListByMainNodeAddr(address)) != null) {
            for (Session session : standBySession) {
                if (session == null) continue;
                this.connector.removeReconnectRequest(session.getRemoteSocketAddress());
                ((MemcachedSession)session).setAllowReconnect(false);
                ((MemcachedSession)session).quit();
            }
        }
        this.connector.removeReconnectRequest(address);
    }

    protected void connect(InetSocketAddressWrapper inetSocketAddressWrapper) throws IOException {
        InetSocketAddress inetSocketAddress = inetSocketAddressWrapper.getInetSocketAddress();
        if (this.connectionPoolSize > 1) {
            log.warn("You are using connection pool for xmemcached client,it's not recommended unless you have test it that it can boost performance in your app.");
        }
        for (int i = 0; i < this.connectionPoolSize; ++i) {
            Future<Boolean> future = null;
            boolean connected = false;
            Exception throwable = null;
            try {
                future = this.connector.connect(inetSocketAddressWrapper);
                if (!future.get(this.connectTimeout, TimeUnit.MILLISECONDS).booleanValue()) {
                    log.error("connect to " + SystemUtils.getRawAddress(inetSocketAddress) + ":" + inetSocketAddress.getPort() + " fail");
                } else {
                    connected = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throwable = e;
                log.error("connect to " + SystemUtils.getRawAddress(inetSocketAddress) + ":" + inetSocketAddress.getPort() + " error", (Throwable)e);
            }
            catch (TimeoutException e) {
                throwable = e;
                log.error("connect to " + SystemUtils.getRawAddress(inetSocketAddress) + ":" + inetSocketAddress.getPort() + " timeout", (Throwable)e);
            }
            catch (Exception e) {
                throwable = e;
                log.error("connect to " + SystemUtils.getRawAddress(inetSocketAddress) + ":" + inetSocketAddress.getPort() + " error", (Throwable)e);
            }
            if (connected) continue;
            if (future != null) {
                future.cancel(true);
            }
            if (this.failureMode) {
                this.connector.addSession(new ClosedMemcachedTCPSession(inetSocketAddressWrapper));
            }
            this.connector.addToWatingQueue(new ReconnectRequest(inetSocketAddressWrapper, 0, this.getHealSessionInterval()));
            log.error("Connect to " + SystemUtils.getRawAddress(inetSocketAddress) + ":" + inetSocketAddress.getPort() + " fail", (Throwable)throwable);
        }
    }

    private final <T> Object fetch0(String key, byte[] keyBytes, CommandType cmdType, long timeout, Transcoder<T> transcoder) throws InterruptedException, TimeoutException, MemcachedException {
        Command command = this.commandFactory.createGetCommand(key, keyBytes, cmdType, this.transcoder);
        this.latchWait(command, timeout, this.sendCommand(command));
        command.getIoBuffer().free();
        this.checkException(command);
        CachedData data = (CachedData)command.getResult();
        if (data == null) {
            return null;
        }
        if (transcoder == null) {
            transcoder = this.transcoder;
        }
        if (cmdType == CommandType.GETS_ONE) {
            return new GetsResponse(data.getCas(), transcoder.decode(data));
        }
        return transcoder.decode(data);
    }

    private final void start0() throws IOException {
        this.registerMBean();
        this.startConnector();
        MemcachedClientNameHolder.clear();
    }

    private final void startConnector() throws IOException {
        if (this.shutdown) {
            this.shutdown = false;
            this.connector.start();
            this.memcachedHandler.start();
            if (AddrUtil.isEnableShutDownHook()) {
                this.shutdownHookThread = new Thread(){

                    public void run() {
                        try {
                            XMemcachedClient.this.isHutdownHookCalled = true;
                            XMemcachedClient.this.shutdown();
                        }
                        catch (IOException e) {
                            log.error("Shutdown XMemcachedClient error", (Throwable)e);
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
            }
        }
    }

    void setMaxQueuedNoReplyOperations(int maxQueuedNoReplyOperations) {
        if (maxQueuedNoReplyOperations <= 1) {
            throw new IllegalArgumentException("maxQueuedNoReplyOperations<=1");
        }
        this.maxQueuedNoReplyOperations = maxQueuedNoReplyOperations;
    }

    private void buildConnector(MemcachedSessionLocator locator, BufferAllocator bufferAllocator, Configuration configuration, Map<SocketOption, Object> socketOptions, CommandFactory commandFactory, Transcoder transcoder) {
        if (locator == null) {
            locator = new ArrayMemcachedSessionLocator();
        }
        if (bufferAllocator == null) {
            bufferAllocator = new SimpleBufferAllocator();
        }
        if (configuration == null) {
            configuration = XMemcachedClientBuilder.getDefaultConfiguration();
        }
        if (transcoder == null) {
            transcoder = new SerializingTranscoder();
        }
        if (commandFactory == null) {
            commandFactory = new TextCommandFactory();
        }
        if (this.name == null) {
            this.name = "MemcachedClient-" + Constants.MEMCACHED_CLIENT_COUNTER.getAndIncrement();
            MemcachedClientNameHolder.setName(this.name);
        }
        this.commandFactory = commandFactory;
        ByteUtils.setProtocol(this.commandFactory.getProtocol());
        log.info("XMemcachedClient is using " + this.commandFactory.getProtocol().name() + " protocol");
        this.commandFactory.setBufferAllocator(bufferAllocator);
        this.shutdown = true;
        this.transcoder = transcoder;
        this.sessionLocator = locator;
        this.connector = this.newConnector(bufferAllocator, configuration, this.sessionLocator, this.commandFactory, this.connectionPoolSize, this.maxQueuedNoReplyOperations);
        this.memcachedHandler = new MemcachedHandler(this);
        this.connector.setHandler(this.memcachedHandler);
        this.connector.setCodecFactory(new MemcachedCodecFactory());
        this.connector.setSessionTimeout(-1L);
        this.connector.setSocketOptions(socketOptions);
        if (this.isFailureMode()) {
            log.info("XMemcachedClient in failure mode.");
        }
        this.connector.setFailureMode(this.failureMode);
        this.sessionLocator.setFailureMode(this.failureMode);
    }

    protected MemcachedConnector newConnector(BufferAllocator bufferAllocator, Configuration configuration, MemcachedSessionLocator memcachedSessionLocator, CommandFactory commandFactory, int poolSize, int maxQueuedNoReplyOperations) {
        configuration.setDispatchMessageThreadCount(0);
        return new MemcachedConnector(configuration, memcachedSessionLocator, bufferAllocator, commandFactory, poolSize, maxQueuedNoReplyOperations);
    }

    private final void registerMBean() {
        if (this.shutdown) {
            XMemcachedMbeanServer.getInstance().registMBean(this, this.getClass().getPackage().getName() + ":type=" + this.getClass().getSimpleName() + "-" + MemcachedClientNameHolder.getName());
        }
    }

    @Override
    public void setOptimizeGet(boolean optimizeGet) {
        this.connector.setOptimizeGet(optimizeGet);
    }

    @Override
    public final void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.connector.setBufferAllocator(bufferAllocator);
    }

    public XMemcachedClient(InetSocketAddress inetSocketAddress, int weight, CommandFactory cmdFactory) throws IOException {
        if (inetSocketAddress == null) {
            throw new IllegalArgumentException("Null InetSocketAddress");
        }
        if (cmdFactory == null) {
            throw new IllegalArgumentException("Null command factory.");
        }
        if (weight <= 0) {
            throw new IllegalArgumentException("weight<=0");
        }
        this.buildConnector(new ArrayMemcachedSessionLocator(), new SimpleBufferAllocator(), XMemcachedClientBuilder.getDefaultConfiguration(), XMemcachedClientBuilder.getDefaultSocketOptions(), cmdFactory, new SerializingTranscoder());
        this.start0();
        this.connect(new InetSocketAddressWrapper(inetSocketAddress, this.serverOrderCount.incrementAndGet(), weight, null));
    }

    public XMemcachedClient(InetSocketAddress inetSocketAddress, int weight) throws IOException {
        this(inetSocketAddress, weight, new TextCommandFactory());
    }

    public XMemcachedClient(InetSocketAddress inetSocketAddress) throws IOException {
        this(inetSocketAddress, 1);
    }

    public XMemcachedClient() throws IOException {
        this.buildConnector(new ArrayMemcachedSessionLocator(), new SimpleBufferAllocator(), XMemcachedClientBuilder.getDefaultConfiguration(), XMemcachedClientBuilder.getDefaultSocketOptions(), new TextCommandFactory(), new SerializingTranscoder());
        this.start0();
    }

    public XMemcachedClient(MemcachedSessionLocator locator, BufferAllocator allocator, Configuration conf, Map<SocketOption, Object> socketOptions, CommandFactory commandFactory, Transcoder transcoder, Map<InetSocketAddress, InetSocketAddress> addressMap, List<MemcachedClientStateListener> stateListeners, Map<InetSocketAddress, AuthInfo> map, int poolSize, long connectTimeout, String name, boolean failureMode) throws IOException {
        this.setConnectTimeout(connectTimeout);
        this.setFailureMode(failureMode);
        this.setName(name);
        this.optimiezeSetReadThreadCount(conf, addressMap == null ? 0 : addressMap.size());
        this.buildConnector(locator, allocator, conf, socketOptions, commandFactory, transcoder);
        if (stateListeners != null) {
            for (MemcachedClientStateListener memcachedClientStateListener : stateListeners) {
                this.addStateListener(memcachedClientStateListener);
            }
        }
        this.setAuthInfoMap(map);
        this.setConnectionPoolSize(poolSize);
        this.start0();
        if (addressMap != null) {
            for (Map.Entry entry : addressMap.entrySet()) {
                InetSocketAddress mainNodeAddr = (InetSocketAddress)entry.getKey();
                InetSocketAddress standbyNodeAddr = (InetSocketAddress)entry.getValue();
                this.connect(new InetSocketAddressWrapper(mainNodeAddr, this.serverOrderCount.incrementAndGet(), 1, null));
                if (standbyNodeAddr == null) continue;
                this.connect(new InetSocketAddressWrapper(standbyNodeAddr, this.serverOrderCount.incrementAndGet(), 1, mainNodeAddr));
            }
        }
    }

    XMemcachedClient(MemcachedSessionLocator locator, BufferAllocator allocator, Configuration conf, Map<SocketOption, Object> socketOptions, CommandFactory commandFactory, Transcoder transcoder, Map<InetSocketAddress, InetSocketAddress> addressMap, int[] weights, List<MemcachedClientStateListener> stateListeners, Map<InetSocketAddress, AuthInfo> infoMap, int poolSize, long connectTimeout, String name, boolean failureMode) throws IOException {
        this.setConnectTimeout(connectTimeout);
        this.setFailureMode(failureMode);
        this.setName(name);
        if (weights == null && addressMap != null) {
            throw new IllegalArgumentException("Null weights");
        }
        if (weights != null && addressMap == null) {
            throw new IllegalArgumentException("Null addressList");
        }
        if (weights != null) {
            for (int weight : weights) {
                if (weight > 0) continue;
                throw new IllegalArgumentException("Some weights<=0");
            }
        }
        if (weights != null && addressMap != null && weights.length < addressMap.size()) {
            throw new IllegalArgumentException("weights.length is less than addressList.size()");
        }
        this.optimiezeSetReadThreadCount(conf, addressMap == null ? 0 : addressMap.size());
        this.buildConnector(locator, allocator, conf, socketOptions, commandFactory, transcoder);
        if (stateListeners != null) {
            for (MemcachedClientStateListener stateListener : stateListeners) {
                this.addStateListener(stateListener);
            }
        }
        this.setAuthInfoMap(infoMap);
        this.setConnectionPoolSize(poolSize);
        this.start0();
        if (addressMap != null && weights != null) {
            int i = 0;
            for (Map.Entry<InetSocketAddress, InetSocketAddress> entry : addressMap.entrySet()) {
                InetSocketAddress mainNodeAddr = entry.getKey();
                InetSocketAddress standbyNodeAddr = entry.getValue();
                this.connect(new InetSocketAddressWrapper(mainNodeAddr, this.serverOrderCount.incrementAndGet(), weights[i], null));
                if (standbyNodeAddr != null) {
                    this.connect(new InetSocketAddressWrapper(standbyNodeAddr, this.serverOrderCount.incrementAndGet(), weights[i], mainNodeAddr));
                }
                ++i;
            }
        }
    }

    private final void optimiezeSetReadThreadCount(Configuration conf, int addressCount) {
        if (conf != null && addressCount > 1 && !this.isWindowsPlatform() && conf.getReadThreadCount() == 0) {
            int threadCount = SystemUtils.getSystemThreadCount();
            conf.setReadThreadCount(addressCount > threadCount ? threadCount : addressCount);
        }
    }

    private final boolean isWindowsPlatform() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().indexOf("windows") >= 0;
    }

    public XMemcachedClient(List<InetSocketAddress> addressList) throws IOException {
        this(addressList, new TextCommandFactory());
    }

    public XMemcachedClient(List<InetSocketAddress> addressList, CommandFactory cmdFactory) throws IOException {
        if (cmdFactory == null) {
            throw new IllegalArgumentException("Null command factory.");
        }
        if (addressList == null || addressList.isEmpty()) {
            throw new IllegalArgumentException("Empty address list");
        }
        SimpleBufferAllocator simpleBufferAllocator = new SimpleBufferAllocator();
        this.buildConnector(new ArrayMemcachedSessionLocator(), simpleBufferAllocator, XMemcachedClientBuilder.getDefaultConfiguration(), XMemcachedClientBuilder.getDefaultSocketOptions(), cmdFactory, new SerializingTranscoder());
        this.start0();
        for (InetSocketAddress inetSocketAddress : addressList) {
            this.connect(new InetSocketAddressWrapper(inetSocketAddress, this.serverOrderCount.incrementAndGet(), 1, null));
        }
    }

    @Override
    public final <T> T get(String key, long timeout, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return (T)this.get0(key, timeout, CommandType.GET_ONE, transcoder);
    }

    @Override
    public final <T> T get(String key, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.get(key, timeout, this.transcoder);
    }

    @Override
    public final <T> T get(String key, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.get(key, this.opTimeout, transcoder);
    }

    @Override
    public final <T> T get(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return this.get(key, this.opTimeout);
    }

    private <T> Object get0(String key, long timeout, CommandType cmdType, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        return this.fetch0(key, keyBytes, cmdType, timeout, transcoder);
    }

    @Override
    public final <T> GetsResponse<T> gets(String key, long timeout, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return (GetsResponse)this.get0(key, timeout, CommandType.GETS_ONE, transcoder);
    }

    @Override
    public final <T> GetsResponse<T> gets(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return this.gets(key, this.opTimeout);
    }

    @Override
    public final <T> GetsResponse<T> gets(String key, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.gets(key, timeout, this.transcoder);
    }

    @Override
    public final <T> GetsResponse<T> gets(String key, Transcoder transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.gets(key, this.opTimeout, transcoder);
    }

    @Override
    public final <T> Map<String, T> get(Collection<String> keyCollections, long timeout, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.getMulti0(keyCollections, timeout, CommandType.GET_MANY, transcoder);
    }

    @Override
    public final <T> Map<String, T> get(Collection<String> keyCollections, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.getMulti0(keyCollections, this.opTimeout, CommandType.GET_MANY, transcoder);
    }

    @Override
    public final <T> Map<String, T> get(Collection<String> keyCollections) throws TimeoutException, InterruptedException, MemcachedException {
        return this.get(keyCollections, this.opTimeout);
    }

    @Override
    public final <T> Map<String, T> get(Collection<String> keyCollections, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.get(keyCollections, timeout, this.transcoder);
    }

    @Override
    public final <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections, long timeout, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.getMulti0(keyCollections, timeout, CommandType.GETS_MANY, transcoder);
    }

    @Override
    public final <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections) throws TimeoutException, InterruptedException, MemcachedException {
        return this.gets(keyCollections, this.opTimeout);
    }

    @Override
    public final <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.gets(keyCollections, timeout, this.transcoder);
    }

    @Override
    public final <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.gets(keyCollections, this.opTimeout, transcoder);
    }

    private final <T> Map<String, T> getMulti0(Collection<String> keys, long timeout, CommandType cmdType, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        CountDownLatch latch;
        ArrayList<Command> commands;
        if (keys == null || keys.size() == 0) {
            return null;
        }
        ArrayList<String> keyCollections = new ArrayList<String>(keys.size());
        for (String key : keys) {
            keyCollections.add(this.preProcessKey(key));
        }
        if (this.connector.getSessionSet().size() <= 1) {
            commands = new ArrayList<Command>(1);
            latch = new CountDownLatch(1);
            commands.add(this.sendGetMultiCommand(keyCollections, latch, cmdType, transcoder));
        } else {
            Collection<List<String>> catalogKeys = this.catalogKeys(keyCollections);
            commands = new ArrayList(catalogKeys.size());
            latch = new CountDownLatch(catalogKeys.size());
            for (List<String> catalogKeyCollection : catalogKeys) {
                commands.add(this.sendGetMultiCommand(catalogKeyCollection, latch, cmdType, transcoder));
            }
        }
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            for (Command getCmd : commands) {
                getCmd.cancel();
            }
            throw new TimeoutException("Timed out waiting for operation");
        }
        return this.reduceResult(cmdType, transcoder, commands);
    }

    private <T> Map<String, T> reduceResult(CommandType cmdType, Transcoder<T> transcoder, List<Command> commands) throws MemcachedException, InterruptedException, TimeoutException {
        HashMap<String, Object> result = new HashMap<String, Object>(commands.size());
        for (Command getCmd : commands) {
            getCmd.getIoBuffer().free();
            this.checkException(getCmd);
            Map map = (Map)getCmd.getResult();
            if (cmdType == CommandType.GET_MANY) {
                for (Map.Entry entry : map.entrySet()) {
                    String decodeKey = this.decodeKey((String)entry.getKey());
                    if (decodeKey == null) continue;
                    result.put(decodeKey, transcoder.decode((CachedData)entry.getValue()));
                }
                continue;
            }
            for (Map.Entry entry : map.entrySet()) {
                GetsResponse<T> getsResponse = new GetsResponse<T>(((CachedData)entry.getValue()).getCas(), transcoder.decode((CachedData)entry.getValue()));
                String decodeKey = this.decodeKey((String)entry.getKey());
                if (decodeKey == null) continue;
                result.put(decodeKey, getsResponse);
            }
        }
        return result;
    }

    private final Collection<List<String>> catalogKeys(Collection<String> keyCollections) {
        HashMap<Session, ArrayList<String>> catalogMap = new HashMap<Session, ArrayList<String>>();
        for (String key : keyCollections) {
            Session index = this.sessionLocator.getSessionByKey(key);
            ArrayList<String> tmpKeys = (ArrayList<String>)catalogMap.get(index);
            if (tmpKeys == null) {
                tmpKeys = new ArrayList<String>(10);
                catalogMap.put(index, tmpKeys);
            }
            tmpKeys.add(key);
        }
        Collection<List<String>> catalogKeys = catalogMap.values();
        return catalogKeys;
    }

    private final <T> Command sendGetMultiCommand(Collection<String> keys, CountDownLatch latch, CommandType cmdType, Transcoder<T> transcoder) throws InterruptedException, TimeoutException, MemcachedException {
        Command command = this.commandFactory.createGetMultiCommand(keys, latch, cmdType, transcoder);
        this.sendCommand(command);
        return command;
    }

    @Override
    public final <T> boolean set(String key, int exp, T value, Transcoder<T> transcoder, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, exp, value);
        return this.sendStoreCommand(this.commandFactory.createSetCommand(key, keyBytes, exp, value, false, transcoder), timeout);
    }

    @Override
    public void setWithNoReply(String key, int exp, Object value) throws InterruptedException, MemcachedException {
        this.setWithNoReply(key, exp, value, this.transcoder);
    }

    @Override
    public <T> void setWithNoReply(String key, int exp, T value, Transcoder<T> transcoder) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, exp, value);
        try {
            this.sendStoreCommand(this.commandFactory.createSetCommand(key, keyBytes, exp, value, true, transcoder), this.opTimeout);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    private final <T> byte[] checkStoreArguments(String key, int exp, T value) {
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        if (value == null) {
            throw new IllegalArgumentException("value could not be null");
        }
        if (exp < 0) {
            throw new IllegalArgumentException("Expire time must be greater than or equal to 0");
        }
        return keyBytes;
    }

    @Override
    public final boolean set(String key, int exp, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.set(key, exp, value, this.opTimeout);
    }

    @Override
    public final boolean set(String key, int exp, Object value, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.set(key, exp, value, this.transcoder, timeout);
    }

    @Override
    public final <T> boolean set(String key, int exp, T value, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.set(key, exp, value, transcoder, this.opTimeout);
    }

    @Override
    public final <T> boolean add(String key, int exp, T value, Transcoder<T> transcoder, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.add0(key, exp, value, transcoder, timeout);
    }

    private <T> boolean add0(String key, int exp, T value, Transcoder<T> transcoder, long timeout) throws InterruptedException, TimeoutException, MemcachedException {
        byte[] keyBytes = this.checkStoreArguments(key, exp, value);
        return this.sendStoreCommand(this.commandFactory.createAddCommand(key, keyBytes, exp, value, false, transcoder), timeout);
    }

    @Override
    public final boolean add(String key, int exp, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.add(key, exp, value, this.opTimeout);
    }

    @Override
    public final boolean add(String key, int exp, Object value, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.add(key, exp, value, this.transcoder, timeout);
    }

    @Override
    public final <T> boolean add(String key, int exp, T value, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.add(key, exp, value, transcoder, this.opTimeout);
    }

    @Override
    public void addWithNoReply(String key, int exp, Object value) throws InterruptedException, MemcachedException {
        this.addWithNoReply(key, exp, value, this.transcoder);
    }

    @Override
    public <T> void addWithNoReply(String key, int exp, T value, Transcoder<T> transcoder) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, exp, value);
        try {
            this.sendStoreCommand(this.commandFactory.createAddCommand(key, keyBytes, exp, value, true, transcoder), this.opTimeout);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public void replaceWithNoReply(String key, int exp, Object value) throws InterruptedException, MemcachedException {
        this.replaceWithNoReply(key, exp, value, this.transcoder);
    }

    @Override
    public <T> void replaceWithNoReply(String key, int exp, T value, Transcoder<T> transcoder) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, exp, value);
        try {
            this.sendStoreCommand(this.commandFactory.createReplaceCommand(key, keyBytes, exp, value, true, transcoder), this.opTimeout);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final <T> boolean replace(String key, int exp, T value, Transcoder<T> transcoder, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, exp, value);
        return this.sendStoreCommand(this.commandFactory.createReplaceCommand(key, keyBytes, exp, value, false, transcoder), timeout);
    }

    @Override
    public final boolean replace(String key, int exp, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.replace(key, exp, value, this.opTimeout);
    }

    @Override
    public final boolean replace(String key, int exp, Object value, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.replace(key, exp, value, this.transcoder, timeout);
    }

    @Override
    public final <T> boolean replace(String key, int exp, T value, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        return this.replace(key, exp, value, transcoder, this.opTimeout);
    }

    @Override
    public final boolean append(String key, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.append(key, value, this.opTimeout);
    }

    @Override
    public final boolean append(String key, Object value, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, 0, value);
        return this.sendStoreCommand(this.commandFactory.createAppendCommand(key, keyBytes, value, false, this.transcoder), timeout);
    }

    @Override
    public void appendWithNoReply(String key, Object value) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, 0, value);
        try {
            this.sendStoreCommand(this.commandFactory.createAppendCommand(key, keyBytes, value, true, this.transcoder), this.opTimeout);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final boolean prepend(String key, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.prepend(key, value, this.opTimeout);
    }

    @Override
    public final boolean prepend(String key, Object value, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, 0, value);
        return this.sendStoreCommand(this.commandFactory.createPrependCommand(key, keyBytes, value, false, this.transcoder), timeout);
    }

    @Override
    public void prependWithNoReply(String key, Object value) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, 0, value);
        try {
            this.sendStoreCommand(this.commandFactory.createPrependCommand(key, keyBytes, value, true, this.transcoder), this.opTimeout);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final boolean cas(String key, int exp, Object value, long cas) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, exp, value, this.opTimeout, cas);
    }

    @Override
    public final <T> boolean cas(String key, int exp, T value, Transcoder<T> transcoder, long timeout, long cas) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = this.checkStoreArguments(key, 0, value);
        return this.sendStoreCommand(this.commandFactory.createCASCommand(key, keyBytes, exp, value, cas, false, transcoder), timeout);
    }

    @Override
    public final boolean cas(String key, int exp, Object value, long timeout, long cas) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, exp, value, this.transcoder, timeout, cas);
    }

    @Override
    public final <T> boolean cas(String key, int exp, T value, Transcoder<T> transcoder, long cas) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, exp, value, transcoder, this.opTimeout, cas);
    }

    private final <T> boolean cas0(String key, int exp, GetsResponse<T> getsResponse, CASOperation<T> operation, Transcoder<T> transcoder, byte[] keyBytes, boolean noreply) throws TimeoutException, InterruptedException, MemcachedException {
        if (operation == null) {
            throw new IllegalArgumentException("CASOperation could not be null");
        }
        if (operation.getMaxTries() < 0) {
            throw new IllegalArgumentException("max tries must be greater than 0");
        }
        GetsResponse<T> result = getsResponse;
        if (result == null) {
            throw new NoValueException("Null GetsResponse for key=" + key);
        }
        for (int tryCount = 0; tryCount <= operation.getMaxTries() && result != null && !this.sendStoreCommand(this.commandFactory.createCASCommand(key, keyBytes, exp, operation.getNewValue(result.getCas(), result.getValue()), result.getCas(), noreply, transcoder), this.opTimeout) && !noreply; ++tryCount) {
            result = this.gets0(key, keyBytes, transcoder);
            if (result != null) continue;
            throw new NoValueException("could not gets the value for Key=" + key + " for cas");
        }
        return true;
    }

    @Override
    public final <T> boolean cas(String key, int exp, CASOperation<T> operation, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        GetsResponse<T> result = this.gets0(key, keyBytes, transcoder);
        return this.cas0(key, exp, result, operation, transcoder, keyBytes, false);
    }

    @Override
    public final <T> boolean cas(String key, int exp, GetsResponse<T> getsReponse, CASOperation<T> operation, Transcoder<T> transcoder) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        return this.cas0(key, exp, getsReponse, operation, transcoder, keyBytes, false);
    }

    @Override
    public final <T> boolean cas(String key, int exp, GetsResponse<T> getsReponse, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, exp, getsReponse, operation, this.transcoder);
    }

    @Override
    public <T> void casWithNoReply(String key, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        this.casWithNoReply(key, 0, operation);
    }

    @Override
    public <T> void casWithNoReply(String key, GetsResponse<T> getsResponse, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        this.casWithNoReply(key, 0, getsResponse, operation);
    }

    @Override
    public <T> void casWithNoReply(String key, int exp, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        GetsResponse<T> result = this.gets0(key, keyBytes, this.transcoder);
        this.casWithNoReply(key, exp, result, operation);
    }

    @Override
    public <T> void casWithNoReply(String key, int exp, GetsResponse<T> getsReponse, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        this.cas0(key, exp, getsReponse, operation, this.transcoder, keyBytes, true);
    }

    @Override
    public final <T> boolean cas(String key, GetsResponse<T> getsReponse, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, 0, getsReponse, operation);
    }

    @Override
    public final <T> boolean cas(String key, int exp, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, exp, operation, this.transcoder);
    }

    @Override
    public final <T> boolean cas(String key, CASOperation<T> operation) throws TimeoutException, InterruptedException, MemcachedException {
        return this.cas(key, 0, operation);
    }

    @Override
    public final boolean delete(String key, int time) throws TimeoutException, InterruptedException, MemcachedException {
        return this.delete0(key, time, 0L, false, this.opTimeout);
    }

    @Override
    public boolean delete(String key, long opTimeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.delete0(key, 0, 0L, false, opTimeout);
    }

    @Override
    public boolean delete(String key, long cas, long opTimeout) throws TimeoutException, InterruptedException, MemcachedException {
        return this.delete0(key, 0, cas, false, opTimeout);
    }

    @Override
    public final void deleteWithNoReply(String key, int time) throws InterruptedException, MemcachedException {
        try {
            this.delete0(key, time, 0L, true, this.opTimeout);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final void deleteWithNoReply(String key) throws InterruptedException, MemcachedException {
        this.deleteWithNoReply(key, 0);
    }

    private boolean delete0(String key, int time, long cas, boolean noreply, long opTimeout) throws MemcachedException, InterruptedException, TimeoutException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        Command command = this.commandFactory.createDeleteCommand(key, keyBytes, time, cas, noreply);
        Session session = this.sendCommand(command);
        if (!command.isNoreply()) {
            this.latchWait(command, opTimeout, session);
            command.getIoBuffer().free();
            this.checkException(command);
            if (command.getResult() == null) {
                throw new MemcachedException("Operation fail,may be caused by networking or timeout");
            }
        } else {
            return false;
        }
        return (Boolean)command.getResult();
    }

    protected void checkException(Command command) throws MemcachedException {
        if (command.getException() != null) {
            if (command.getException() instanceof MemcachedException) {
                throw (MemcachedException)command.getException();
            }
            throw new MemcachedException(command.getException());
        }
    }

    @Override
    public boolean touch(String key, int exp, long opTimeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        CountDownLatch latch = new CountDownLatch(1);
        Command command = this.commandFactory.createTouchCommand(key, keyBytes, latch, exp, false);
        this.latchWait(command, opTimeout, this.sendCommand(command));
        command.getIoBuffer().free();
        this.checkException(command);
        if (command.getResult() == null) {
            throw new MemcachedException("Operation fail,may be caused by networking or timeout");
        }
        return (Boolean)command.getResult();
    }

    @Override
    public boolean touch(String key, int exp) throws TimeoutException, InterruptedException, MemcachedException {
        return this.touch(key, exp, this.opTimeout);
    }

    @Override
    public <T> T getAndTouch(String key, int newExp, long opTimeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        CountDownLatch latch = new CountDownLatch(1);
        Command command = this.commandFactory.createGetAndTouchCommand(key, keyBytes, latch, newExp, false);
        this.latchWait(command, opTimeout, this.sendCommand(command));
        command.getIoBuffer().free();
        this.checkException(command);
        CachedData data = (CachedData)command.getResult();
        if (data == null) {
            return null;
        }
        return this.transcoder.decode(data);
    }

    @Override
    public <T> T getAndTouch(String key, int newExp) throws TimeoutException, InterruptedException, MemcachedException {
        return this.getAndTouch(key, newExp, this.opTimeout);
    }

    @Override
    public final long incr(String key, long delta) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, 0L, CommandType.INCR, false, this.opTimeout, 0);
    }

    @Override
    public long incr(String key, long delta, long initValue) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, initValue, CommandType.INCR, false, this.opTimeout, 0);
    }

    @Override
    public long incr(String key, long delta, long initValue, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, initValue, CommandType.INCR, false, timeout, 0);
    }

    @Override
    public long incr(String key, long delta, long initValue, long timeout, int exp) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, initValue, CommandType.INCR, false, timeout, exp);
    }

    @Override
    public final void incrWithNoReply(String key, long delta) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        try {
            this.sendIncrOrDecrCommand(key, delta, 0L, CommandType.INCR, true, this.opTimeout, 0);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final void decrWithNoReply(String key, long delta) throws InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        try {
            this.sendIncrOrDecrCommand(key, delta, 0L, CommandType.DECR, true, this.opTimeout, 0);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final long decr(String key, long delta) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, 0L, CommandType.DECR, false, this.opTimeout, 0);
    }

    @Override
    public long decr(String key, long delta, long initValue) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, initValue, CommandType.DECR, false, this.opTimeout, 0);
    }

    @Override
    public long decr(String key, long delta, long initValue, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, initValue, CommandType.DECR, false, timeout, 0);
    }

    @Override
    public long decr(String key, long delta, long initValue, long timeout, int exp) throws TimeoutException, InterruptedException, MemcachedException {
        key = this.preProcessKey(key);
        return this.sendIncrOrDecrCommand(key, delta, initValue, CommandType.DECR, false, timeout, exp);
    }

    @Override
    public final void flushAll() throws TimeoutException, InterruptedException, MemcachedException {
        this.flushAll(this.opTimeout);
    }

    @Override
    public void flushAllWithNoReply() throws InterruptedException, MemcachedException {
        try {
            this.flushAllMemcachedServers(this.opTimeout, true, 0);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public void flushAllWithNoReply(int exptime) throws InterruptedException, MemcachedException {
        try {
            this.flushAllMemcachedServers(this.opTimeout, true, exptime);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public void flushAllWithNoReply(InetSocketAddress address) throws MemcachedException, InterruptedException {
        try {
            this.flushSpecialMemcachedServer(address, this.opTimeout, true, 0);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public void flushAllWithNoReply(InetSocketAddress address, int exptime) throws MemcachedException, InterruptedException {
        try {
            this.flushSpecialMemcachedServer(address, this.opTimeout, true, exptime);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final void flushAll(int exptime, long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        this.flushAllMemcachedServers(timeout, false, exptime);
    }

    @Override
    public final void flushAll(long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        this.flushAllMemcachedServers(timeout, false, 0);
    }

    private void flushAllMemcachedServers(long timeout, boolean noreply, int exptime) throws MemcachedException, InterruptedException, TimeoutException {
        Set<Session> sessions = this.connector.getSessionSet();
        CountDownLatch latch = new CountDownLatch(sessions.size());
        ArrayList commands = new ArrayList(sessions.size());
        for (Session session : sessions) {
            if (session != null && !session.isClosed()) {
                Command command = this.commandFactory.createFlushAllCommand(latch, exptime, noreply);
                session.write(command);
                continue;
            }
            latch.countDown();
        }
        if (!noreply && !latch.await(timeout, TimeUnit.MILLISECONDS)) {
            for (Command cmd : commands) {
                cmd.cancel();
            }
            throw new TimeoutException("Timed out waiting for operation");
        }
    }

    @Override
    public void setLoggingLevelVerbosity(InetSocketAddress address, int level) throws TimeoutException, InterruptedException, MemcachedException {
        this.setMemcachedLoggingLevel(address, level, false);
    }

    private void setMemcachedLoggingLevel(InetSocketAddress address, int level, boolean noreply) throws MemcachedException, InterruptedException, TimeoutException {
        if (address == null) {
            throw new IllegalArgumentException("Null adderss");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Queue<Session> sessionQueue = this.connector.getSessionByAddress(address);
        if (sessionQueue == null || sessionQueue.peek() == null) {
            throw new MemcachedException("could not find session for " + SystemUtils.getRawAddress(address) + ":" + address.getPort() + ",maybe it have not been connected");
        }
        Command command = this.commandFactory.createVerbosityCommand(latch, level, noreply);
        Session session = sessionQueue.peek();
        session.write(command);
        if (!noreply) {
            this.latchWait(command, this.opTimeout, session);
        }
    }

    @Override
    public void setLoggingLevelVerbosityWithNoReply(InetSocketAddress address, int level) throws InterruptedException, MemcachedException {
        try {
            this.setMemcachedLoggingLevel(address, level, true);
        }
        catch (TimeoutException e) {
            throw new MemcachedException(e);
        }
    }

    @Override
    public final void flushAll(InetSocketAddress address) throws MemcachedException, InterruptedException, TimeoutException {
        this.flushAll(address, this.opTimeout);
    }

    @Override
    public final void flushAll(InetSocketAddress address, long timeout) throws MemcachedException, InterruptedException, TimeoutException {
        this.flushSpecialMemcachedServer(address, timeout, false, 0);
    }

    @Override
    public final void flushAll(InetSocketAddress address, long timeout, int exptime) throws MemcachedException, InterruptedException, TimeoutException {
        this.flushSpecialMemcachedServer(address, timeout, false, exptime);
    }

    private void flushSpecialMemcachedServer(InetSocketAddress address, long timeout, boolean noreply, int exptime) throws MemcachedException, InterruptedException, TimeoutException {
        if (address == null) {
            throw new IllegalArgumentException("Null adderss");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Queue<Session> sessionQueue = this.connector.getSessionByAddress(address);
        if (sessionQueue == null || sessionQueue.peek() == null) {
            throw new MemcachedException("could not find session for " + SystemUtils.getRawAddress(address) + ":" + address.getPort() + ",maybe it have not been connected");
        }
        Command command = this.commandFactory.createFlushAllCommand(latch, exptime, noreply);
        Session session = sessionQueue.peek();
        session.write(command);
        if (!noreply) {
            this.latchWait(command, timeout, session);
        }
    }

    @Override
    public final void flushAll(String host) throws TimeoutException, InterruptedException, MemcachedException {
        this.flushAll(AddrUtil.getOneAddress(host), this.opTimeout);
    }

    @Override
    public final Map<String, String> stats(InetSocketAddress address) throws MemcachedException, InterruptedException, TimeoutException {
        return this.stats(address, this.opTimeout);
    }

    @Override
    public final Map<String, String> stats(InetSocketAddress address, long timeout) throws MemcachedException, InterruptedException, TimeoutException {
        if (address == null) {
            throw new IllegalArgumentException("Null inetSocketAddress");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Queue<Session> sessionQueue = this.connector.getSessionByAddress(address);
        if (sessionQueue == null || sessionQueue.peek() == null) {
            throw new MemcachedException("could not find session for " + SystemUtils.getRawAddress(address) + ":" + address.getPort() + ",maybe it have not been connected");
        }
        Command command = this.commandFactory.createStatsCommand(address, latch, null);
        Session session = sessionQueue.peek();
        session.write(command);
        this.latchWait(command, timeout, session);
        return (Map)command.getResult();
    }

    @Override
    public final Map<InetSocketAddress, Map<String, String>> getStats() throws MemcachedException, InterruptedException, TimeoutException {
        return this.getStats(this.opTimeout);
    }

    @Override
    public final Map<InetSocketAddress, Map<String, String>> getStatsByItem(String itemName) throws MemcachedException, InterruptedException, TimeoutException {
        return this.getStatsByItem(itemName, this.opTimeout);
    }

    @Override
    public final Map<InetSocketAddress, Map<String, String>> getStatsByItem(String itemName, long timeout) throws MemcachedException, InterruptedException, TimeoutException {
        Set<Session> sessionSet = this.connector.getSessionSet();
        HashMap<InetSocketAddress, Map<String, String>> collectResult = new HashMap<InetSocketAddress, Map<String, String>>();
        if (sessionSet.size() == 0) {
            return collectResult;
        }
        CountDownLatch latch = new CountDownLatch(sessionSet.size());
        ArrayList<Command> commands = new ArrayList<Command>(sessionSet.size());
        for (Session session : sessionSet) {
            Command command = this.commandFactory.createStatsCommand(session.getRemoteSocketAddress(), latch, itemName);
            session.write(command);
            commands.add(command);
        }
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            for (Command command : commands) {
                command.cancel();
            }
            throw new TimeoutException("Timed out waiting for operation");
        }
        for (Command command : commands) {
            this.checkException(command);
            collectResult.put(((ServerAddressAware)((Object)command)).getServer(), (Map)command.getResult());
        }
        return collectResult;
    }

    @Override
    public final Map<InetSocketAddress, String> getVersions() throws TimeoutException, InterruptedException, MemcachedException {
        return this.getVersions(this.opTimeout);
    }

    @Override
    public final Map<InetSocketAddress, String> getVersions(long timeout) throws TimeoutException, InterruptedException, MemcachedException {
        Set<Session> sessionSet = this.connector.getSessionSet();
        HashMap<InetSocketAddress, String> collectResult = new HashMap<InetSocketAddress, String>();
        if (sessionSet.size() == 0) {
            return collectResult;
        }
        CountDownLatch latch = new CountDownLatch(sessionSet.size());
        ArrayList<Command> commands = new ArrayList<Command>(sessionSet.size());
        for (Session session : sessionSet) {
            Command command = this.commandFactory.createVersionCommand(latch, session.getRemoteSocketAddress());
            session.write(command);
            commands.add(command);
        }
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            for (Command command : commands) {
                command.cancel();
            }
            throw new TimeoutException("Timed out waiting for operation");
        }
        for (Command command : commands) {
            this.checkException(command);
            collectResult.put(((ServerAddressAware)((Object)command)).getServer(), (String)command.getResult());
        }
        return collectResult;
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStats(long timeout) throws MemcachedException, InterruptedException, TimeoutException {
        return this.getStatsByItem(null, timeout);
    }

    protected void shutdown0() {
    }

    @Override
    public final void shutdown() throws IOException {
        if (this.shutdown) {
            return;
        }
        this.shutdown0();
        this.shutdown = true;
        this.connector.shuttingDown();
        this.connector.quitAllSessions();
        this.connector.stop();
        this.memcachedHandler.stop();
        XMemcachedMbeanServer.getInstance().shutdown();
        if (AddrUtil.isEnableShutDownHook() && !this.isHutdownHookCalled) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long sendIncrOrDecrCommand(String key, long delta, long initValue, CommandType cmdType, boolean noreply, long operationTimeout, int exp) throws InterruptedException, TimeoutException, MemcachedException {
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        Command command = this.commandFactory.createIncrDecrCommand(key, keyBytes, delta, initValue, exp, cmdType, noreply);
        Session session = this.sendCommand(command);
        if (!command.isNoreply()) {
            this.latchWait(command, operationTimeout, session);
            command.getIoBuffer().free();
            this.checkException(command);
            if (command.getResult() == null) {
                throw new MemcachedException("Operation fail,may be caused by networking or timeout");
            }
            Object result = command.getResult();
            if (result instanceof String) {
                if (((String)result).equals("NOT_FOUND")) {
                    if (this.add0(key, exp, String.valueOf(initValue), this.transcoder, this.opTimeout)) {
                        return initValue;
                    }
                    return this.sendIncrOrDecrCommand(key, delta, initValue, cmdType, noreply, operationTimeout, exp);
                }
                throw new MemcachedException("Unknown result type for incr/decr:" + result.getClass() + ",result=" + result);
            }
            return (Long)command.getResult();
        }
        return -1L;
    }

    @Override
    public void setConnectionPoolSize(int poolSize) {
        if (!this.shutdown && this.getAvaliableServers().size() > 0) {
            throw new IllegalStateException("Xmemcached client has been started");
        }
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize<=0");
        }
        this.connectionPoolSize = poolSize;
        this.connector.setConnectionPoolSize(poolSize);
    }

    @Override
    public final boolean delete(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return this.delete(key, 0);
    }

    @Override
    public final Transcoder getTranscoder() {
        return this.transcoder;
    }

    @Override
    public final void setTranscoder(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    private final <T> boolean sendStoreCommand(Command command, long timeout) throws InterruptedException, TimeoutException, MemcachedException {
        Session session = this.sendCommand(command);
        if (!command.isNoreply()) {
            this.latchWait(command, timeout, session);
            command.getIoBuffer().free();
            this.checkException(command);
            if (command.getResult() == null) {
                throw new MemcachedException("Operation fail,may be caused by networking or timeout");
            }
        } else {
            return false;
        }
        return (Boolean)command.getResult();
    }

    protected void latchWait(Command cmd, long timeout, Session session) throws InterruptedException, TimeoutException {
        if (cmd.getLatch().await(timeout, TimeUnit.MILLISECONDS)) {
            AtomicInteger counter = this.getContinuousTimeoutCounter(session);
            if (counter.get() > 0) {
                counter.set(0);
            }
        } else {
            cmd.cancel();
            AtomicInteger counter = this.getContinuousTimeoutCounter(session);
            if (counter.incrementAndGet() > this.timeoutExceptionThreshold) {
                log.warn(session + " exceeded continuous timeout threshold,we will close it.");
                try {
                    counter.set(0);
                    session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new TimeoutException("Timed out(" + timeout + " milliseconds) waiting for operation while connected to " + session);
        }
    }

    private AtomicInteger getContinuousTimeoutCounter(Session session) {
        AtomicInteger oldCounter;
        AtomicInteger counter = (AtomicInteger)session.getAttribute(CONTINUOUS_TIMEOUT_COUNTER);
        if (counter == null && (oldCounter = (AtomicInteger)session.setAttributeIfAbsent(CONTINUOUS_TIMEOUT_COUNTER, counter = new AtomicInteger(0))) != null) {
            counter = oldCounter;
        }
        return counter;
    }

    @Override
    @Deprecated
    public final Collection<InetSocketAddress> getAvaliableServers() {
        return this.getAvailableServers();
    }

    @Override
    public Collection<InetSocketAddress> getAvailableServers() {
        Set<Session> sessionSet = this.connector.getSessionSet();
        HashSet<InetSocketAddress> result = new HashSet<InetSocketAddress>();
        for (Session session : sessionSet) {
            result.add(session.getRemoteSocketAddress());
        }
        return Collections.unmodifiableSet(result);
    }

    public final int getConnectionSizeBySocketAddress(InetSocketAddress address) {
        Queue<Session> sessionList = this.connector.getSessionByAddress(address);
        return sessionList == null ? 0 : sessionList.size();
    }

    @Override
    public void addStateListener(MemcachedClientStateListener listener) {
        MemcachedClientStateListenerAdapter adapter = new MemcachedClientStateListenerAdapter(listener, this);
        this.stateListenerAdapters.add(adapter);
        this.connector.addStateListener(adapter);
    }

    @Override
    public Collection<MemcachedClientStateListener> getStateListeners() {
        ArrayList<MemcachedClientStateListener> result = new ArrayList<MemcachedClientStateListener>(this.stateListenerAdapters.size());
        for (MemcachedClientStateListenerAdapter adapter : this.stateListenerAdapters) {
            result.add(adapter.getMemcachedClientStateListener());
        }
        return result;
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.transcoder.setPrimitiveAsString(primitiveAsString);
    }

    @Override
    public void removeStateListener(MemcachedClientStateListener listener) {
        for (MemcachedClientStateListenerAdapter adapter : this.stateListenerAdapters) {
            if (!adapter.getMemcachedClientStateListener().equals(listener)) continue;
            this.stateListenerAdapters.remove(adapter);
            this.connector.removeStateListener(adapter);
        }
    }

    @Override
    public Protocol getProtocol() {
        return this.commandFactory.getProtocol();
    }

    @Override
    public boolean isSanitizeKeys() {
        return this.sanitizeKeys;
    }

    @Override
    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    private String decodeKey(String key) throws MemcachedException, InterruptedException, TimeoutException {
        try {
            key = this.sanitizeKeys ? URLDecoder.decode(key, "UTF-8") : key;
        }
        catch (UnsupportedEncodingException e) {
            throw new MemcachedException("Unsupport encoding utf-8 when decodeKey", e);
        }
        String ns = NAMESPACE_LOCAL.get();
        if (ns != null && ns.trim().length() > 0) {
            String nsValue = this.getNamespace(ns);
            try {
                if (nsValue == null || !key.startsWith(nsValue)) {
                    return null;
                }
                key = key.substring(nsValue.length() + 1);
            }
            catch (Exception e) {
                throw new MemcachedException("Exception occured when decode key.", e);
            }
        }
        return key;
    }

    private String preProcessKey(String key) throws MemcachedException, InterruptedException {
        key = this.keyProvider.process(key);
        try {
            key = this.sanitizeKeys ? URLEncoder.encode(key, "UTF-8") : key;
        }
        catch (UnsupportedEncodingException e) {
            throw new MemcachedException("Unsupport encoding utf-8 when sanitize key", e);
        }
        String ns = NAMESPACE_LOCAL.get();
        if (ns != null && ns.trim().length() > 0) {
            try {
                key = this.getNamespace(ns) + ":" + key;
            }
            catch (TimeoutException e) {
                throw new MemcachedException("Timeout occured when gettting namespace value.", e);
            }
        }
        return key;
    }

    @Override
    public void invalidateNamespace(String ns, long opTimeout) throws MemcachedException, InterruptedException, TimeoutException {
        String key = this.keyProvider.process(this.getNSKey(ns));
        this.sendIncrOrDecrCommand(key, 1L, System.nanoTime(), CommandType.INCR, false, opTimeout, 0);
    }

    @Override
    public void invalidateNamespace(String ns) throws MemcachedException, InterruptedException, TimeoutException {
        this.invalidateNamespace(ns, this.opTimeout);
    }

    public String getNamespace(String ns) throws TimeoutException, InterruptedException, MemcachedException {
        String key = this.keyProvider.process(this.getNSKey(ns));
        byte[] keyBytes = ByteUtils.getBytes(key);
        ByteUtils.checkKey(keyBytes);
        Object item = this.fetch0(key, keyBytes, CommandType.GET_ONE, this.opTimeout, this.transcoder);
        while (item == null) {
            item = String.valueOf(System.nanoTime());
            boolean added = this.add0(key, 0, item, this.transcoder, this.opTimeout);
            if (added) continue;
            item = this.fetch0(key, keyBytes, CommandType.GET_ONE, this.opTimeout, this.transcoder);
        }
        String namespace = item.toString();
        if (!ByteUtils.isNumber(namespace)) {
            throw new IllegalStateException("Namespace key already has value.The key is:" + key + ",and the value is:" + namespace);
        }
        return namespace;
    }

    private String getNSKey(String ns) {
        String key = "namespace:" + ns;
        return key;
    }

    @Override
    public Counter getCounter(String key, long initialValue) {
        return new Counter(this, key, initialValue);
    }

    @Override
    public Counter getCounter(String key) {
        return new Counter(this, key, 0L);
    }

    @Override
    @Deprecated
    public KeyIterator getKeyIterator(InetSocketAddress address) throws MemcachedException, TimeoutException, InterruptedException {
        if (address == null) {
            throw new IllegalArgumentException("null address");
        }
        Queue<Session> sessions = this.connector.getSessionByAddress(address);
        if (sessions == null || sessions.size() == 0) {
            throw new MemcachedException("The special memcached server has not been connected," + address);
        }
        Session session = sessions.peek();
        CountDownLatch latch = new CountDownLatch(1);
        Command command = this.commandFactory.createStatsCommand(session.getRemoteSocketAddress(), latch, "items");
        session.write(command);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Operation timeout");
        }
        if (command.getException() != null) {
            if (command.getException() instanceof MemcachedException) {
                throw (MemcachedException)command.getException();
            }
            throw new MemcachedException("stats items failed", command.getException());
        }
        Map result = (Map)command.getResult();
        LinkedList<Integer> itemNumberList = new LinkedList<Integer>();
        for (Map.Entry entry : result.entrySet()) {
            String key = (String)entry.getKey();
            String[] keys = key.split(":");
            if (keys.length != 3 || !keys[2].equals("number") || !keys[0].equals("items") || Integer.parseInt((String)entry.getValue()) <= 0) continue;
            itemNumberList.add(Integer.parseInt(keys[1]));
        }
        return new KeyIteratorImpl(itemNumberList, this, address);
    }

    @Override
    public void setEnableHealSession(boolean enableHealSession) {
        if (this.connector == null) {
            throw new IllegalStateException("The client has not been started.");
        }
        this.connector.setEnableHealSession(enableHealSession);
    }

    @Override
    public void setFailureMode(boolean failureMode) {
        this.failureMode = failureMode;
        if (this.sessionLocator != null) {
            this.sessionLocator.setFailureMode(failureMode);
        }
        if (this.connector != null) {
            this.connector.setFailureMode(failureMode);
        }
    }

    @Override
    public boolean isFailureMode() {
        return this.failureMode;
    }

    @Override
    public Queue<ReconnectRequest> getReconnectRequestQueue() {
        return this.connector != null ? this.connector.getReconnectRequestQueue() : null;
    }
}

